/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class IntersectActor
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#ifndef _OSGINTERSECTACTORBASE_H_
#define _OSGINTERSECTACTORBASE_H_
#ifdef __sgi
#pragma once
#endif

#include <OSGConfig.h>

#include <OSGSystemDef.h>

#include <OSGNewActionTypes.h>
#include <OSGBasicActorBase.h>               // Parent
#include <OSGMultiFunctorStore.h>      // EnterStore
#include <OSGMultiFunctorStore.h>      // LeaveStore

#include <OSGBaseTypes.h>   // HitDistance type
#include <OSGNodePtr.h>   // HitObject type
#include <OSGBaseTypes.h>   // HitTriangleIndex type
#include <OSGVector.h>   // HitNormal type
#include <OSGBaseTypes.h>   // MaxDistance type
#include <OSGBaseTypes.h>   // ScaleFactor type
#include <OSGLine.h>   // Ray type

OSG_BEGIN_NAMESPACE

class OSG_SYSTEMLIB_DLLMAPPING IntersectActorBase : public BasicActorBase
{
    /*====  PUBLIC  =========================================================*/
  public:
    /*---------------------------------------- ------------------------------*/
    /*! \name    Types                                                       */
    /*! \{                                                                   */

    typedef BasicActorBase::ResultE ResultE;
    typedef BasicActorBase::Functor Functor;

    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    Destructor                                                  */
    /*! \{                                                                   */

    virtual ~IntersectActorBase(void);

    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    Start/Stop                                                  */
    /*! \{                                                                   */

    virtual ResultE start(void);
    virtual ResultE stop (void);

    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    Enter/Leave                                                 */
    /*! \{                                                                   */

    virtual ResultE enterNode(FunctorArgumentType &funcArg);
    virtual ResultE leaveNode(FunctorArgumentType &funcArg);

    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    Enter Registration                                          */
    /*! \{                                                                   */

    static void regClassEnter         (const Functor            &refFunc,
                                       const FieldContainerType &refType );
           void regEnter              (const Functor            &refFunc,
                                       const FieldContainerType &refType );
    static void regDefaultClassEnter  (const Functor            &refFunc );
           void regDefaultEnter       (const Functor            &refFunc );

    static void unregClassEnter       (const FieldContainerType &refType );
           void unregEnter            (const FieldContainerType &refType );
    static void unregDefaultClassEnter(      void                        );
           void unregDefaultEnter     (      void                        );
    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    Leave Registration                                          */
    /*! \{                                                                   */

    static void regClassLeave         (const Functor            &refFunc,
                                       const FieldContainerType &refType );
           void regLeave              (const Functor            &refFunc,
                                       const FieldContainerType &refType );
    static void regDefaultClassLeave  (const Functor            &refFunc );
           void regDefaultLeave       (const Functor            &refFunc );

    static void unregClassLeave       (const FieldContainerType &refType );
           void unregLeave            (const FieldContainerType &refType );
    static void unregDefaultClassLeave(      void                        );
           void unregDefaultLeave     (      void                        );

    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    Public State Access                                         */
    /*! \{                                                                   */

    inline const Real32 &getHitDistance(void                             ) const;
    inline       Real32 &getHitDistance(void                             );
    inline       void               setHitDistance(const Real32 &stateVal);
    inline const bool &getHit(void                             ) const;
    inline       bool &getHit(void                             );
    inline       void               setHit(const bool &stateVal);
    inline const NodePtr &getHitObject(void                             ) const;
    inline       NodePtr &getHitObject(void                             );
    inline       void               setHitObject(const NodePtr &stateVal);
    inline const Int32 &getHitTriangleIndex(void                             ) const;
    inline       Int32 &getHitTriangleIndex(void                             );
    inline       void               setHitTriangleIndex(const Int32 &stateVal);
    inline const Vec3f &getHitNormal(void                             ) const;
    inline       Vec3f &getHitNormal(void                             );
    inline       void               setHitNormal(const Vec3f &stateVal);
    inline const Real32 &getMaxDistance(void                             ) const;
    inline       Real32 &getMaxDistance(void                             );
    inline       void               setMaxDistance(const Real32 &stateVal);
    inline const Real32 &getScaleFactor(void                             ) const;
    inline       Real32 &getScaleFactor(void                             );
    inline       void               setScaleFactor(const Real32 &stateVal);
    inline const Line &getRay(void                             ) const;
    inline       Line &getRay(void                             );
    inline       void               setRay(const Line &stateVal);

    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    State Management                                            */
    /*! \{                                                                   */

#ifdef OSG_NEWACTION_STATESLOTINTERFACE
    virtual UInt32          createStateClone  (void                       );
    virtual void            destroyStateClone (UInt32          slotId     );
#else
    virtual ActorBaseState *createStateClone  (void                       );
    virtual void            destroyStateClone (ActorBaseState *pStateClone);
#endif

    virtual void            createInitialState(void                       );
    virtual void            deleteInitialState(void                       );

    /*! \}                                                                   */
    /*====  PROTECTED  ======================================================*/
  protected:
    /*-----------------------------------------------------------------------*/
    /*! \name    Types & Friends                                             */
    /*! \{                                                                   */

    class   IntersectActorBaseState;
    friend  class OSG::IntersectActorBase::IntersectActorBaseState;

    typedef IntersectActorBaseState     StateType;
    typedef BasicActorBase::StateType  ParentStateType;
    typedef MultiFunctorStore EnterStoreType;
    typedef MultiFunctorStore LeaveStoreType;

    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    State Class                                                 */
    /*! \{                                                                   */

    class OSG_SYSTEMLIB_DLLMAPPING IntersectActorBaseState : public ParentStateType
    {
      public:
        inline   IntersectActorBaseState(void                                );
        inline   IntersectActorBaseState(const IntersectActorBaseState &source);

        virtual ~IntersectActorBaseState(void                                );

        inline const Real32 &getScaleFactor(void) const;
        inline       Real32 &getScaleFactor(void);
        inline const Line &getRay(void) const;
        inline       Line &getRay(void);

      private:
        Real32 _stateScaleFactor;
        Line _stateRay;
    };

    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    Constructor                                                 */
    /*! \{                                                                   */

    IntersectActorBase(void);

    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    Event Notification                                          */
    /*! \{                                                                   */

    virtual void addEvent(NewActionBase *pAction, UInt32 actorId);
    virtual void subEvent(NewActionBase *pAction, UInt32 actorId);

    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    State Access                                                */
    /*! \{                                                                   */

    inline const IntersectActorBaseState *getCastState(void) const;
    inline       IntersectActorBaseState *getCastState(void);


    /*! \}                                                                   */
    /*====  PRIVATE  ========================================================*/
  private:
    typedef BasicActorBase Inherited;

    static EnterStoreType *_pClassEnterStore;
    static LeaveStoreType *_pClassLeaveStore;

    Real32 _stateHitDistance;
    bool _stateHit;
    NodePtr _stateHitObject;
    Int32 _stateHitTriangleIndex;
    Vec3f _stateHitNormal;
    Real32 _stateMaxDistance;

    EnterStoreType         _instanceEnterStore;
    LeaveStoreType         _instanceLeaveStore;
};

OSG_END_NAMESPACE

#include <OSGIntersectActorBase.inl>

#define OSGINTERSECTACTORBASE_HEADER_CVSID "@(#)$Id:"

#endif /* _OSGINTERSECTACTORBASE_H_ */
