/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class ShaderParameterMMatrix!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILESHADERPARAMETERMMATRIXINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGShaderParameterMMatrixBase.h"
#include "OSGShaderParameterMMatrix.h"


OSG_BEGIN_NAMESPACE

const OSG::BitVector  ShaderParameterMMatrixBase::ValueFieldMask = 
    (TypeTraits<BitVector>::One << ShaderParameterMMatrixBase::ValueFieldId);

const OSG::BitVector ShaderParameterMMatrixBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var Matrix          ShaderParameterMMatrixBase::_mfValue
    parameter value
*/

//! ShaderParameterMMatrix description

FieldDescription *ShaderParameterMMatrixBase::_desc[] = 
{
    new FieldDescription(MFMatrix::getClassType(), 
                     "value", 
                     ValueFieldId, ValueFieldMask,
                     false,
                     (FieldAccessMethod) &ShaderParameterMMatrixBase::getMFValue)
};


FieldContainerType ShaderParameterMMatrixBase::_type(
    "ShaderParameterMMatrix",
    "ShaderParameter",
    NULL,
    (PrototypeCreateF) &ShaderParameterMMatrixBase::createEmpty,
    ShaderParameterMMatrix::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(ShaderParameterMMatrixBase, ShaderParameterMMatrixPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &ShaderParameterMMatrixBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &ShaderParameterMMatrixBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr ShaderParameterMMatrixBase::shallowCopy(void) const 
{ 
    ShaderParameterMMatrixPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const ShaderParameterMMatrix *>(this)); 

    return returnValue; 
}

UInt32 ShaderParameterMMatrixBase::getContainerSize(void) const 
{ 
    return sizeof(ShaderParameterMMatrix); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void ShaderParameterMMatrixBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((ShaderParameterMMatrixBase *) &other, whichField);
}
#else
void ShaderParameterMMatrixBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((ShaderParameterMMatrixBase *) &other, whichField, sInfo);
}
void ShaderParameterMMatrixBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void ShaderParameterMMatrixBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

    _mfValue.terminateShare(uiAspect, this->getContainerSize());
}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

ShaderParameterMMatrixBase::ShaderParameterMMatrixBase(void) :
    _mfValue                  (), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

ShaderParameterMMatrixBase::ShaderParameterMMatrixBase(const ShaderParameterMMatrixBase &source) :
    _mfValue                  (source._mfValue                  ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

ShaderParameterMMatrixBase::~ShaderParameterMMatrixBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 ShaderParameterMMatrixBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (ValueFieldMask & whichField))
    {
        returnValue += _mfValue.getBinSize();
    }


    return returnValue;
}

void ShaderParameterMMatrixBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (ValueFieldMask & whichField))
    {
        _mfValue.copyToBin(pMem);
    }


}

void ShaderParameterMMatrixBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (ValueFieldMask & whichField))
    {
        _mfValue.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void ShaderParameterMMatrixBase::executeSyncImpl(      ShaderParameterMMatrixBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (ValueFieldMask & whichField))
        _mfValue.syncWith(pOther->_mfValue);


}
#else
void ShaderParameterMMatrixBase::executeSyncImpl(      ShaderParameterMMatrixBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);


    if(FieldBits::NoField != (ValueFieldMask & whichField))
        _mfValue.syncWith(pOther->_mfValue, sInfo);


}

void ShaderParameterMMatrixBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

    if(FieldBits::NoField != (ValueFieldMask & whichField))
        _mfValue.beginEdit(uiAspect, uiContainerSize);

}
#endif



OSG_END_NAMESPACE

#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<ShaderParameterMMatrixPtr>::_type("ShaderParameterMMatrixPtr", "ShaderParameterPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(ShaderParameterMMatrixPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(ShaderParameterMMatrixPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: OSGShaderParameterMMatrixBase.cpp,v 1.1 2007/03/09 18:11:48 a-m-z Exp $";
    static Char8 cvsid_hpp       [] = OSGSHADERPARAMETERMMATRIXBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGSHADERPARAMETERMMATRIXBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGSHADERPARAMETERMMATRIXFIELDS_HEADER_CVSID;
}

OSG_END_NAMESPACE

