/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class MultiDisplayWindow
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#ifndef _OSGMULTIDISPLAYWINDOWBASE_H_
#define _OSGMULTIDISPLAYWINDOWBASE_H_
#ifdef __sgi
#pragma once
#endif


#include <OSGConfig.h>
#include <OSGSystemDef.h>

#include <OSGBaseTypes.h>
#include <OSGRefPtr.h>
#include <OSGCoredNodePtr.h>

#include <OSGClusterWindow.h> // Parent

#include <OSGUInt32Fields.h> // HServers type
#include <OSGUInt32Fields.h> // VServers type
#include <OSGBoolFields.h> // ManageClientViewports type
#include <OSGInt32Fields.h> // XOverlap type
#include <OSGInt32Fields.h> // YOverlap type

#include <OSGMultiDisplayWindowFields.h>

OSG_BEGIN_NAMESPACE

class MultiDisplayWindow;
class BinaryDataHandler;

//! \brief MultiDisplayWindow Base Class.

class OSG_SYSTEMLIB_DLLMAPPING MultiDisplayWindowBase : public ClusterWindow
{
  private:

    typedef ClusterWindow    Inherited;

    /*==========================  PUBLIC  =================================*/
  public:

    typedef MultiDisplayWindowPtr  Ptr;

    enum
    {
        HServersFieldId              = Inherited::NextFieldId,
        VServersFieldId              = HServersFieldId              + 1,
        ManageClientViewportsFieldId = VServersFieldId              + 1,
        XOverlapFieldId              = ManageClientViewportsFieldId + 1,
        YOverlapFieldId              = XOverlapFieldId              + 1,
        NextFieldId                  = YOverlapFieldId              + 1
    };

    static const OSG::BitVector HServersFieldMask;
    static const OSG::BitVector VServersFieldMask;
    static const OSG::BitVector ManageClientViewportsFieldMask;
    static const OSG::BitVector XOverlapFieldMask;
    static const OSG::BitVector YOverlapFieldMask;


    static const OSG::BitVector MTInfluenceMask;

    /*---------------------------------------------------------------------*/
    /*! \name                    Class Get                                 */
    /*! \{                                                                 */

    static        FieldContainerType &getClassType    (void); 
    static        UInt32              getClassTypeId  (void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                FieldContainer Get                            */
    /*! \{                                                                 */

    virtual       FieldContainerType &getType  (void); 
    virtual const FieldContainerType &getType  (void) const; 

    virtual       UInt32              getContainerSize(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Get                                 */
    /*! \{                                                                 */

           SFUInt32            *getSFHServers       (void);
           SFUInt32            *getSFVServers       (void);
           SFBool              *getSFManageClientViewports(void);
           SFInt32             *getSFXOverlap       (void);
           SFInt32             *getSFYOverlap       (void);

           UInt32              &getHServers       (void);
     const UInt32              &getHServers       (void) const;
           UInt32              &getVServers       (void);
     const UInt32              &getVServers       (void) const;
           bool                &getManageClientViewports(void);
     const bool                &getManageClientViewports(void) const;
           Int32               &getXOverlap       (void);
     const Int32               &getXOverlap       (void) const;
           Int32               &getYOverlap       (void);
     const Int32               &getYOverlap       (void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Set                                 */
    /*! \{                                                                 */

     void setHServers       ( const UInt32 &value );
     void setVServers       ( const UInt32 &value );
     void setManageClientViewports( const bool &value );
     void setXOverlap       ( const Int32 &value );
     void setYOverlap       ( const Int32 &value );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Binary Access                              */
    /*! \{                                                                 */

    virtual UInt32 getBinSize (const BitVector         &whichField);
    virtual void   copyToBin  (      BinaryDataHandler &pMem,
                               const BitVector         &whichField);
    virtual void   copyFromBin(      BinaryDataHandler &pMem,
                               const BitVector         &whichField);


    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Construction                               */
    /*! \{                                                                 */

    static  MultiDisplayWindowPtr      create          (void); 
    static  MultiDisplayWindowPtr      createEmpty     (void); 

    /*! \}                                                                 */

    /*---------------------------------------------------------------------*/
    /*! \name                       Copy                                   */
    /*! \{                                                                 */

    virtual FieldContainerPtr     shallowCopy     (void) const; 

    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/
  protected:

    /*---------------------------------------------------------------------*/
    /*! \name                      Fields                                  */
    /*! \{                                                                 */

    SFUInt32            _sfHServers;
    SFUInt32            _sfVServers;
    SFBool              _sfManageClientViewports;
    SFInt32             _sfXOverlap;
    SFInt32             _sfYOverlap;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */

    MultiDisplayWindowBase(void);
    MultiDisplayWindowBase(const MultiDisplayWindowBase &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~MultiDisplayWindowBase(void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

#if !defined(OSG_FIXED_MFIELDSYNC)
    void executeSyncImpl(      MultiDisplayWindowBase *pOther,
                         const BitVector         &whichField);

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField);
#else
    void executeSyncImpl(      MultiDisplayWindowBase *pOther,
                         const BitVector         &whichField,
                         const SyncInfo          &sInfo     );

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField,
                               const SyncInfo          &sInfo);

    virtual void execBeginEdit     (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

            void execBeginEditImpl (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

    virtual void onDestroyAspect(UInt32 uiId, UInt32 uiAspect);
#endif

    /*! \}                                                                 */
    /*==========================  PRIVATE  ================================*/
  private:

    friend class FieldContainer;

    static FieldDescription   *_desc[];
    static FieldContainerType  _type;


    // prohibit default functions (move to 'public' if you need one)
    void operator =(const MultiDisplayWindowBase &source);
};

//---------------------------------------------------------------------------
//   Exported Types
//---------------------------------------------------------------------------


typedef MultiDisplayWindowBase *MultiDisplayWindowBaseP;

typedef osgIF<MultiDisplayWindowBase::isNodeCore,
              CoredNodePtr<MultiDisplayWindow>,
              FieldContainer::attempt_to_create_CoredNodePtr_on_non_NodeCore_FC
              >::_IRet MultiDisplayWindowNodePtr;

typedef RefPtr<MultiDisplayWindowPtr> MultiDisplayWindowRefPtr;

OSG_END_NAMESPACE

#define OSGMULTIDISPLAYWINDOWBASE_HEADER_CVSID "@(#)$Id: FCBaseTemplate_h.h,v 1.40 2005/07/20 00:10:14 vossg Exp $"

#endif /* _OSGMULTIDISPLAYWINDOWBASE_H_ */
