/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class SwitchMaterial!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE


//! access the type of the class
inline
OSG::FieldContainerType &SwitchMaterialBase::getClassType(void)
{
    return _type; 
} 

//! access the numerical type of the class
inline
OSG::UInt32 SwitchMaterialBase::getClassTypeId(void) 
{
    return _type.getId(); 
} 

//! create a new instance of the class
inline
SwitchMaterialPtr SwitchMaterialBase::create(void) 
{
    SwitchMaterialPtr fc; 

    if(getClassType().getPrototype() != OSG::NullFC) 
    {
        fc = SwitchMaterialPtr::dcast(
            getClassType().getPrototype()-> shallowCopy()); 
    }
    
    return fc; 
}

//! create an empty new instance of the class, do not copy the prototype
inline
SwitchMaterialPtr SwitchMaterialBase::createEmpty(void) 
{ 
    SwitchMaterialPtr returnValue; 
    
    newPtr(returnValue); 

    return returnValue; 
}


/*------------------------------ get -----------------------------------*/

//! Get the SwitchMaterial::_mfMaterials field.
inline
MFMaterialPtr *SwitchMaterialBase::getMFMaterials(void)
{
    return &_mfMaterials;
}

//! Get the SwitchMaterial::_sfChoice field.
inline
SFUInt32 *SwitchMaterialBase::getSFChoice(void)
{
    return &_sfChoice;
}


//! Get the value of the SwitchMaterial::_sfChoice field.
inline
UInt32 &SwitchMaterialBase::getChoice(void)
{
    return _sfChoice.getValue();
}

//! Get the value of the SwitchMaterial::_sfChoice field.
inline
const UInt32 &SwitchMaterialBase::getChoice(void) const
{
    return _sfChoice.getValue();
}

//! Set the value of the SwitchMaterial::_sfChoice field.
inline
void SwitchMaterialBase::setChoice(const UInt32 &value)
{
    _sfChoice.setValue(value);
}


//! Get the value of the \a index element the SwitchMaterial::_mfMaterials field.
inline
MaterialPtr &SwitchMaterialBase::getMaterials(const UInt32 index)
{
    return _mfMaterials[index];
}

//! Get the SwitchMaterial::_mfMaterials field.
inline
MFMaterialPtr &SwitchMaterialBase::getMaterials(void)
{
    return _mfMaterials;
}

//! Get the SwitchMaterial::_mfMaterials field.
inline
const MFMaterialPtr &SwitchMaterialBase::getMaterials(void) const
{
    return _mfMaterials;
}

OSG_END_NAMESPACE

#define OSGSWITCHMATERIALBASE_INLINE_CVSID "@(#)$Id: OSGSwitchMaterialBase.inl,v 1.2 2006/02/20 17:04:44 dirk Exp $"

