/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class Geometry!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEGEOMETRYINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGGeometryBase.h"
#include "OSGGeometry.h"


OSG_BEGIN_NAMESPACE

const OSG::BitVector  GeometryBase::TypesFieldMask = 
    (TypeTraits<BitVector>::One << GeometryBase::TypesFieldId);

const OSG::BitVector  GeometryBase::LengthsFieldMask = 
    (TypeTraits<BitVector>::One << GeometryBase::LengthsFieldId);

const OSG::BitVector  GeometryBase::PositionsFieldMask = 
    (TypeTraits<BitVector>::One << GeometryBase::PositionsFieldId);

const OSG::BitVector  GeometryBase::NormalsFieldMask = 
    (TypeTraits<BitVector>::One << GeometryBase::NormalsFieldId);

const OSG::BitVector  GeometryBase::ColorsFieldMask = 
    (TypeTraits<BitVector>::One << GeometryBase::ColorsFieldId);

const OSG::BitVector  GeometryBase::SecondaryColorsFieldMask = 
    (TypeTraits<BitVector>::One << GeometryBase::SecondaryColorsFieldId);

const OSG::BitVector  GeometryBase::TexCoordsFieldMask = 
    (TypeTraits<BitVector>::One << GeometryBase::TexCoordsFieldId);

const OSG::BitVector  GeometryBase::TexCoords1FieldMask = 
    (TypeTraits<BitVector>::One << GeometryBase::TexCoords1FieldId);

const OSG::BitVector  GeometryBase::TexCoords2FieldMask = 
    (TypeTraits<BitVector>::One << GeometryBase::TexCoords2FieldId);

const OSG::BitVector  GeometryBase::TexCoords3FieldMask = 
    (TypeTraits<BitVector>::One << GeometryBase::TexCoords3FieldId);

const OSG::BitVector  GeometryBase::TexCoords4FieldMask = 
    (TypeTraits<BitVector>::One << GeometryBase::TexCoords4FieldId);

const OSG::BitVector  GeometryBase::TexCoords5FieldMask = 
    (TypeTraits<BitVector>::One << GeometryBase::TexCoords5FieldId);

const OSG::BitVector  GeometryBase::TexCoords6FieldMask = 
    (TypeTraits<BitVector>::One << GeometryBase::TexCoords6FieldId);

const OSG::BitVector  GeometryBase::TexCoords7FieldMask = 
    (TypeTraits<BitVector>::One << GeometryBase::TexCoords7FieldId);

const OSG::BitVector  GeometryBase::IndicesFieldMask = 
    (TypeTraits<BitVector>::One << GeometryBase::IndicesFieldId);

const OSG::BitVector  GeometryBase::IndexMappingFieldMask = 
    (TypeTraits<BitVector>::One << GeometryBase::IndexMappingFieldId);

const OSG::BitVector  GeometryBase::DlistCacheFieldMask = 
    (TypeTraits<BitVector>::One << GeometryBase::DlistCacheFieldId);

const OSG::BitVector  GeometryBase::GLIdFieldMask = 
    (TypeTraits<BitVector>::One << GeometryBase::GLIdFieldId);

const OSG::BitVector  GeometryBase::IgnoreGLForAspectFieldMask = 
    (TypeTraits<BitVector>::One << GeometryBase::IgnoreGLForAspectFieldId);

const OSG::BitVector  GeometryBase::MinindexFieldMask = 
    (TypeTraits<BitVector>::One << GeometryBase::MinindexFieldId);

const OSG::BitVector  GeometryBase::MaxindexFieldMask = 
    (TypeTraits<BitVector>::One << GeometryBase::MaxindexFieldId);

const OSG::BitVector  GeometryBase::LowindicesFieldMask = 
    (TypeTraits<BitVector>::One << GeometryBase::LowindicesFieldId);

const OSG::BitVector  GeometryBase::HighindicesFieldMask = 
    (TypeTraits<BitVector>::One << GeometryBase::HighindicesFieldId);

const OSG::BitVector  GeometryBase::VboFieldMask = 
    (TypeTraits<BitVector>::One << GeometryBase::VboFieldId);

const OSG::BitVector GeometryBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var GeoPTypesPtr    GeometryBase::_sfTypes
    The types property contains the primitive's types. Legal values are          everything that can be passed to glBegin(). There have to be as many          types as lengths.
*/
/*! \var GeoPLengthsPtr  GeometryBase::_sfLengths
    The lengths property contains the number of vertices to use for the          corresponding primitive. There have to be as many  lengths as types.
*/
/*! \var GeoPositionsPtr GeometryBase::_sfPositions
    The positions property contains the position data.
*/
/*! \var GeoNormalsPtr   GeometryBase::_sfNormals
    The normals property contains the normal data.
*/
/*! \var GeoColorsPtr    GeometryBase::_sfColors
    The colors property contains the color data. See \ref          PageSystemMaterialChunk for details on when these colors are used.
*/
/*! \var GeoColorsPtr    GeometryBase::_sfSecondaryColors
    The secondaryColors property contains the secondary colors data.         Secondary colors are used for some higher level shaders.
*/
/*! \var GeoTexCoordsPtr GeometryBase::_sfTexCoords
    The texCoords property contains the texture coordinate data.
*/
/*! \var GeoTexCoordsPtr GeometryBase::_sfTexCoords1
    The texCoords1 property contains the texture coordinate data for the         second texture. See \ref PageSystemTextureChunk for multi-texturing.
*/
/*! \var GeoTexCoordsPtr GeometryBase::_sfTexCoords2
    The texCoords2 property contains the texture coordinate data for the         third texture. See \ref PageSystemTextureChunk for multi-texturing.
*/
/*! \var GeoTexCoordsPtr GeometryBase::_sfTexCoords3
    The texCoords3 property contains the texture coordinate data for the         fourth texture. See \ref PageSystemTextureChunk for multi-texturing.
*/
/*! \var GeoTexCoordsPtr GeometryBase::_sfTexCoords4
    The texCoords4 property contains the texture coordinate data for the         fifth texture. See \ref PageSystemTextureChunk for multi-texturing.
*/
/*! \var GeoTexCoordsPtr GeometryBase::_sfTexCoords5
    The texCoords5 property contains the texture coordinate data for the         sixth texture. See \ref PageSystemTextureChunk for multi-texturing.
*/
/*! \var GeoTexCoordsPtr GeometryBase::_sfTexCoords6
    The texCoords6 property contains the texture coordinate data for the         seventh texture. See \ref PageSystemTextureChunk for multi-texturing.
*/
/*! \var GeoTexCoordsPtr GeometryBase::_sfTexCoords7
    The texCoords7 property contains the texture coordinate data for the         eighth texture. See \ref PageSystemTextureChunk for multi-texturing.
*/
/*! \var GeoIndicesPtr   GeometryBase::_sfIndices
    The indices property contains the index data. See \ref          PageSystemGeoIndexing for a description of the indexing options.
*/
/*! \var UInt16          GeometryBase::_mfIndexMapping
    The indexMapping property contains the definition which index element         is used for which attribute data. See \ref PageSystemGeoIndexing for         a description of the indexing options.
*/
/*! \var bool            GeometryBase::_sfDlistCache
    Flag to activate caching the geometry inside a display list.
*/
/*! \var Int32           GeometryBase::_sfGLId
    The dlist id, if used.
*/
/*! \var Int32           GeometryBase::_sfIgnoreGLForAspect
    The dlist id, if used.
*/
/*! \var UInt32          GeometryBase::_sfMinindex
    The minimum index used (for single-indexed mode only).
*/
/*! \var UInt32          GeometryBase::_sfMaxindex
    The maximum index used (for single-indexed mode only).
*/
/*! \var UInt32          GeometryBase::_mfLowindices
    For each primitive (entry in types) the lowest index used (for single-indexed mode only).
*/
/*! \var UInt32          GeometryBase::_mfHighindices
    For each primitive (entry in types) the highest index used (for single-indexed mode only).
*/
/*! \var bool            GeometryBase::_sfVbo
    Flag to activate vbo rendering.
*/

//! Geometry description

FieldDescription *GeometryBase::_desc[] = 
{
    new FieldDescription(SFGeoPTypesPtr::getClassType(), 
                     "types", 
                     TypesFieldId, TypesFieldMask,
                     false,
                     (FieldAccessMethod) &GeometryBase::getSFTypes),
    new FieldDescription(SFGeoPLengthsPtr::getClassType(), 
                     "lengths", 
                     LengthsFieldId, LengthsFieldMask,
                     false,
                     (FieldAccessMethod) &GeometryBase::getSFLengths),
    new FieldDescription(SFGeoPositionsPtr::getClassType(), 
                     "positions", 
                     PositionsFieldId, PositionsFieldMask,
                     false,
                     (FieldAccessMethod) &GeometryBase::getSFPositions),
    new FieldDescription(SFGeoNormalsPtr::getClassType(), 
                     "normals", 
                     NormalsFieldId, NormalsFieldMask,
                     false,
                     (FieldAccessMethod) &GeometryBase::getSFNormals),
    new FieldDescription(SFGeoColorsPtr::getClassType(), 
                     "colors", 
                     ColorsFieldId, ColorsFieldMask,
                     false,
                     (FieldAccessMethod) &GeometryBase::getSFColors),
    new FieldDescription(SFGeoColorsPtr::getClassType(), 
                     "secondaryColors", 
                     SecondaryColorsFieldId, SecondaryColorsFieldMask,
                     false,
                     (FieldAccessMethod) &GeometryBase::getSFSecondaryColors),
    new FieldDescription(SFGeoTexCoordsPtr::getClassType(), 
                     "texCoords", 
                     TexCoordsFieldId, TexCoordsFieldMask,
                     false,
                     (FieldAccessMethod) &GeometryBase::getSFTexCoords),
    new FieldDescription(SFGeoTexCoordsPtr::getClassType(), 
                     "texCoords1", 
                     TexCoords1FieldId, TexCoords1FieldMask,
                     false,
                     (FieldAccessMethod) &GeometryBase::getSFTexCoords1),
    new FieldDescription(SFGeoTexCoordsPtr::getClassType(), 
                     "texCoords2", 
                     TexCoords2FieldId, TexCoords2FieldMask,
                     false,
                     (FieldAccessMethod) &GeometryBase::getSFTexCoords2),
    new FieldDescription(SFGeoTexCoordsPtr::getClassType(), 
                     "texCoords3", 
                     TexCoords3FieldId, TexCoords3FieldMask,
                     false,
                     (FieldAccessMethod) &GeometryBase::getSFTexCoords3),
    new FieldDescription(SFGeoTexCoordsPtr::getClassType(), 
                     "texCoords4", 
                     TexCoords4FieldId, TexCoords4FieldMask,
                     false,
                     (FieldAccessMethod) &GeometryBase::getSFTexCoords4),
    new FieldDescription(SFGeoTexCoordsPtr::getClassType(), 
                     "texCoords5", 
                     TexCoords5FieldId, TexCoords5FieldMask,
                     false,
                     (FieldAccessMethod) &GeometryBase::getSFTexCoords5),
    new FieldDescription(SFGeoTexCoordsPtr::getClassType(), 
                     "texCoords6", 
                     TexCoords6FieldId, TexCoords6FieldMask,
                     false,
                     (FieldAccessMethod) &GeometryBase::getSFTexCoords6),
    new FieldDescription(SFGeoTexCoordsPtr::getClassType(), 
                     "texCoords7", 
                     TexCoords7FieldId, TexCoords7FieldMask,
                     false,
                     (FieldAccessMethod) &GeometryBase::getSFTexCoords7),
    new FieldDescription(SFGeoIndicesPtr::getClassType(), 
                     "indices", 
                     IndicesFieldId, IndicesFieldMask,
                     false,
                     (FieldAccessMethod) &GeometryBase::getSFIndices),
    new FieldDescription(MFUInt16::getClassType(), 
                     "indexMapping", 
                     IndexMappingFieldId, IndexMappingFieldMask,
                     false,
                     (FieldAccessMethod) &GeometryBase::getMFIndexMapping),
    new FieldDescription(SFBool::getClassType(), 
                     "dlistCache", 
                     DlistCacheFieldId, DlistCacheFieldMask,
                     false,
                     (FieldAccessMethod) &GeometryBase::getSFDlistCache),
    new FieldDescription(SFInt32::getClassType(), 
                     "GLId", 
                     GLIdFieldId, GLIdFieldMask,
                     true,
                     (FieldAccessMethod) &GeometryBase::getSFGLId),
    new FieldDescription(SFInt32::getClassType(), 
                     "IgnoreGLForAspect", 
                     IgnoreGLForAspectFieldId, IgnoreGLForAspectFieldMask,
                     true,
                     (FieldAccessMethod) &GeometryBase::getSFIgnoreGLForAspect),
    new FieldDescription(SFUInt32::getClassType(), 
                     "minindex", 
                     MinindexFieldId, MinindexFieldMask,
                     true,
                     (FieldAccessMethod) &GeometryBase::getSFMinindex),
    new FieldDescription(SFUInt32::getClassType(), 
                     "maxindex", 
                     MaxindexFieldId, MaxindexFieldMask,
                     true,
                     (FieldAccessMethod) &GeometryBase::getSFMaxindex),
    new FieldDescription(MFUInt32::getClassType(), 
                     "lowindices", 
                     LowindicesFieldId, LowindicesFieldMask,
                     true,
                     (FieldAccessMethod) &GeometryBase::getMFLowindices),
    new FieldDescription(MFUInt32::getClassType(), 
                     "highindices", 
                     HighindicesFieldId, HighindicesFieldMask,
                     true,
                     (FieldAccessMethod) &GeometryBase::getMFHighindices),
    new FieldDescription(SFBool::getClassType(), 
                     "vbo", 
                     VboFieldId, VboFieldMask,
                     false,
                     (FieldAccessMethod) &GeometryBase::getSFVbo)
};


FieldContainerType GeometryBase::_type(
    "Geometry",
    "MaterialDrawable",
    NULL,
    (PrototypeCreateF) &GeometryBase::createEmpty,
    Geometry::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(GeometryBase, GeometryPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &GeometryBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &GeometryBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr GeometryBase::shallowCopy(void) const 
{ 
    GeometryPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const Geometry *>(this)); 

    return returnValue; 
}

UInt32 GeometryBase::getContainerSize(void) const 
{ 
    return sizeof(Geometry); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void GeometryBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((GeometryBase *) &other, whichField);
}
#else
void GeometryBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((GeometryBase *) &other, whichField, sInfo);
}
void GeometryBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void GeometryBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

    _mfIndexMapping.terminateShare(uiAspect, this->getContainerSize());
    _mfLowindices.terminateShare(uiAspect, this->getContainerSize());
    _mfHighindices.terminateShare(uiAspect, this->getContainerSize());
}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

GeometryBase::GeometryBase(void) :
    _sfTypes                  (), 
    _sfLengths                (), 
    _sfPositions              (), 
    _sfNormals                (), 
    _sfColors                 (), 
    _sfSecondaryColors        (), 
    _sfTexCoords              (), 
    _sfTexCoords1             (), 
    _sfTexCoords2             (), 
    _sfTexCoords3             (), 
    _sfTexCoords4             (), 
    _sfTexCoords5             (), 
    _sfTexCoords6             (), 
    _sfTexCoords7             (), 
    _sfIndices                (), 
    _mfIndexMapping           (), 
    _sfDlistCache             (bool(true)), 
    _sfGLId                   (Int32(0)), 
    _sfIgnoreGLForAspect      (Int32(-1)), 
    _sfMinindex               (), 
    _sfMaxindex               (), 
    _mfLowindices             (), 
    _mfHighindices            (), 
    _sfVbo                    (bool(false)), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

GeometryBase::GeometryBase(const GeometryBase &source) :
    _sfTypes                  (source._sfTypes                  ), 
    _sfLengths                (source._sfLengths                ), 
    _sfPositions              (source._sfPositions              ), 
    _sfNormals                (source._sfNormals                ), 
    _sfColors                 (source._sfColors                 ), 
    _sfSecondaryColors        (source._sfSecondaryColors        ), 
    _sfTexCoords              (source._sfTexCoords              ), 
    _sfTexCoords1             (source._sfTexCoords1             ), 
    _sfTexCoords2             (source._sfTexCoords2             ), 
    _sfTexCoords3             (source._sfTexCoords3             ), 
    _sfTexCoords4             (source._sfTexCoords4             ), 
    _sfTexCoords5             (source._sfTexCoords5             ), 
    _sfTexCoords6             (source._sfTexCoords6             ), 
    _sfTexCoords7             (source._sfTexCoords7             ), 
    _sfIndices                (source._sfIndices                ), 
    _mfIndexMapping           (source._mfIndexMapping           ), 
    _sfDlistCache             (source._sfDlistCache             ), 
    _sfGLId                   (source._sfGLId                   ), 
    _sfIgnoreGLForAspect      (source._sfIgnoreGLForAspect      ), 
    _sfMinindex               (source._sfMinindex               ), 
    _sfMaxindex               (source._sfMaxindex               ), 
    _mfLowindices             (source._mfLowindices             ), 
    _mfHighindices            (source._mfHighindices            ), 
    _sfVbo                    (source._sfVbo                    ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

GeometryBase::~GeometryBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 GeometryBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (TypesFieldMask & whichField))
    {
        returnValue += _sfTypes.getBinSize();
    }

    if(FieldBits::NoField != (LengthsFieldMask & whichField))
    {
        returnValue += _sfLengths.getBinSize();
    }

    if(FieldBits::NoField != (PositionsFieldMask & whichField))
    {
        returnValue += _sfPositions.getBinSize();
    }

    if(FieldBits::NoField != (NormalsFieldMask & whichField))
    {
        returnValue += _sfNormals.getBinSize();
    }

    if(FieldBits::NoField != (ColorsFieldMask & whichField))
    {
        returnValue += _sfColors.getBinSize();
    }

    if(FieldBits::NoField != (SecondaryColorsFieldMask & whichField))
    {
        returnValue += _sfSecondaryColors.getBinSize();
    }

    if(FieldBits::NoField != (TexCoordsFieldMask & whichField))
    {
        returnValue += _sfTexCoords.getBinSize();
    }

    if(FieldBits::NoField != (TexCoords1FieldMask & whichField))
    {
        returnValue += _sfTexCoords1.getBinSize();
    }

    if(FieldBits::NoField != (TexCoords2FieldMask & whichField))
    {
        returnValue += _sfTexCoords2.getBinSize();
    }

    if(FieldBits::NoField != (TexCoords3FieldMask & whichField))
    {
        returnValue += _sfTexCoords3.getBinSize();
    }

    if(FieldBits::NoField != (TexCoords4FieldMask & whichField))
    {
        returnValue += _sfTexCoords4.getBinSize();
    }

    if(FieldBits::NoField != (TexCoords5FieldMask & whichField))
    {
        returnValue += _sfTexCoords5.getBinSize();
    }

    if(FieldBits::NoField != (TexCoords6FieldMask & whichField))
    {
        returnValue += _sfTexCoords6.getBinSize();
    }

    if(FieldBits::NoField != (TexCoords7FieldMask & whichField))
    {
        returnValue += _sfTexCoords7.getBinSize();
    }

    if(FieldBits::NoField != (IndicesFieldMask & whichField))
    {
        returnValue += _sfIndices.getBinSize();
    }

    if(FieldBits::NoField != (IndexMappingFieldMask & whichField))
    {
        returnValue += _mfIndexMapping.getBinSize();
    }

    if(FieldBits::NoField != (DlistCacheFieldMask & whichField))
    {
        returnValue += _sfDlistCache.getBinSize();
    }

    if(FieldBits::NoField != (GLIdFieldMask & whichField))
    {
        returnValue += _sfGLId.getBinSize();
    }

    if(FieldBits::NoField != (IgnoreGLForAspectFieldMask & whichField))
    {
        returnValue += _sfIgnoreGLForAspect.getBinSize();
    }

    if(FieldBits::NoField != (MinindexFieldMask & whichField))
    {
        returnValue += _sfMinindex.getBinSize();
    }

    if(FieldBits::NoField != (MaxindexFieldMask & whichField))
    {
        returnValue += _sfMaxindex.getBinSize();
    }

    if(FieldBits::NoField != (LowindicesFieldMask & whichField))
    {
        returnValue += _mfLowindices.getBinSize();
    }

    if(FieldBits::NoField != (HighindicesFieldMask & whichField))
    {
        returnValue += _mfHighindices.getBinSize();
    }

    if(FieldBits::NoField != (VboFieldMask & whichField))
    {
        returnValue += _sfVbo.getBinSize();
    }


    return returnValue;
}

void GeometryBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (TypesFieldMask & whichField))
    {
        _sfTypes.copyToBin(pMem);
    }

    if(FieldBits::NoField != (LengthsFieldMask & whichField))
    {
        _sfLengths.copyToBin(pMem);
    }

    if(FieldBits::NoField != (PositionsFieldMask & whichField))
    {
        _sfPositions.copyToBin(pMem);
    }

    if(FieldBits::NoField != (NormalsFieldMask & whichField))
    {
        _sfNormals.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ColorsFieldMask & whichField))
    {
        _sfColors.copyToBin(pMem);
    }

    if(FieldBits::NoField != (SecondaryColorsFieldMask & whichField))
    {
        _sfSecondaryColors.copyToBin(pMem);
    }

    if(FieldBits::NoField != (TexCoordsFieldMask & whichField))
    {
        _sfTexCoords.copyToBin(pMem);
    }

    if(FieldBits::NoField != (TexCoords1FieldMask & whichField))
    {
        _sfTexCoords1.copyToBin(pMem);
    }

    if(FieldBits::NoField != (TexCoords2FieldMask & whichField))
    {
        _sfTexCoords2.copyToBin(pMem);
    }

    if(FieldBits::NoField != (TexCoords3FieldMask & whichField))
    {
        _sfTexCoords3.copyToBin(pMem);
    }

    if(FieldBits::NoField != (TexCoords4FieldMask & whichField))
    {
        _sfTexCoords4.copyToBin(pMem);
    }

    if(FieldBits::NoField != (TexCoords5FieldMask & whichField))
    {
        _sfTexCoords5.copyToBin(pMem);
    }

    if(FieldBits::NoField != (TexCoords6FieldMask & whichField))
    {
        _sfTexCoords6.copyToBin(pMem);
    }

    if(FieldBits::NoField != (TexCoords7FieldMask & whichField))
    {
        _sfTexCoords7.copyToBin(pMem);
    }

    if(FieldBits::NoField != (IndicesFieldMask & whichField))
    {
        _sfIndices.copyToBin(pMem);
    }

    if(FieldBits::NoField != (IndexMappingFieldMask & whichField))
    {
        _mfIndexMapping.copyToBin(pMem);
    }

    if(FieldBits::NoField != (DlistCacheFieldMask & whichField))
    {
        _sfDlistCache.copyToBin(pMem);
    }

    if(FieldBits::NoField != (GLIdFieldMask & whichField))
    {
        _sfGLId.copyToBin(pMem);
    }

    if(FieldBits::NoField != (IgnoreGLForAspectFieldMask & whichField))
    {
        _sfIgnoreGLForAspect.copyToBin(pMem);
    }

    if(FieldBits::NoField != (MinindexFieldMask & whichField))
    {
        _sfMinindex.copyToBin(pMem);
    }

    if(FieldBits::NoField != (MaxindexFieldMask & whichField))
    {
        _sfMaxindex.copyToBin(pMem);
    }

    if(FieldBits::NoField != (LowindicesFieldMask & whichField))
    {
        _mfLowindices.copyToBin(pMem);
    }

    if(FieldBits::NoField != (HighindicesFieldMask & whichField))
    {
        _mfHighindices.copyToBin(pMem);
    }

    if(FieldBits::NoField != (VboFieldMask & whichField))
    {
        _sfVbo.copyToBin(pMem);
    }


}

void GeometryBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (TypesFieldMask & whichField))
    {
        _sfTypes.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (LengthsFieldMask & whichField))
    {
        _sfLengths.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (PositionsFieldMask & whichField))
    {
        _sfPositions.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (NormalsFieldMask & whichField))
    {
        _sfNormals.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ColorsFieldMask & whichField))
    {
        _sfColors.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (SecondaryColorsFieldMask & whichField))
    {
        _sfSecondaryColors.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (TexCoordsFieldMask & whichField))
    {
        _sfTexCoords.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (TexCoords1FieldMask & whichField))
    {
        _sfTexCoords1.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (TexCoords2FieldMask & whichField))
    {
        _sfTexCoords2.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (TexCoords3FieldMask & whichField))
    {
        _sfTexCoords3.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (TexCoords4FieldMask & whichField))
    {
        _sfTexCoords4.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (TexCoords5FieldMask & whichField))
    {
        _sfTexCoords5.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (TexCoords6FieldMask & whichField))
    {
        _sfTexCoords6.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (TexCoords7FieldMask & whichField))
    {
        _sfTexCoords7.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (IndicesFieldMask & whichField))
    {
        _sfIndices.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (IndexMappingFieldMask & whichField))
    {
        _mfIndexMapping.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (DlistCacheFieldMask & whichField))
    {
        _sfDlistCache.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (GLIdFieldMask & whichField))
    {
        _sfGLId.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (IgnoreGLForAspectFieldMask & whichField))
    {
        _sfIgnoreGLForAspect.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (MinindexFieldMask & whichField))
    {
        _sfMinindex.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (MaxindexFieldMask & whichField))
    {
        _sfMaxindex.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (LowindicesFieldMask & whichField))
    {
        _mfLowindices.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (HighindicesFieldMask & whichField))
    {
        _mfHighindices.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (VboFieldMask & whichField))
    {
        _sfVbo.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void GeometryBase::executeSyncImpl(      GeometryBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (TypesFieldMask & whichField))
        _sfTypes.syncWith(pOther->_sfTypes);

    if(FieldBits::NoField != (LengthsFieldMask & whichField))
        _sfLengths.syncWith(pOther->_sfLengths);

    if(FieldBits::NoField != (PositionsFieldMask & whichField))
        _sfPositions.syncWith(pOther->_sfPositions);

    if(FieldBits::NoField != (NormalsFieldMask & whichField))
        _sfNormals.syncWith(pOther->_sfNormals);

    if(FieldBits::NoField != (ColorsFieldMask & whichField))
        _sfColors.syncWith(pOther->_sfColors);

    if(FieldBits::NoField != (SecondaryColorsFieldMask & whichField))
        _sfSecondaryColors.syncWith(pOther->_sfSecondaryColors);

    if(FieldBits::NoField != (TexCoordsFieldMask & whichField))
        _sfTexCoords.syncWith(pOther->_sfTexCoords);

    if(FieldBits::NoField != (TexCoords1FieldMask & whichField))
        _sfTexCoords1.syncWith(pOther->_sfTexCoords1);

    if(FieldBits::NoField != (TexCoords2FieldMask & whichField))
        _sfTexCoords2.syncWith(pOther->_sfTexCoords2);

    if(FieldBits::NoField != (TexCoords3FieldMask & whichField))
        _sfTexCoords3.syncWith(pOther->_sfTexCoords3);

    if(FieldBits::NoField != (TexCoords4FieldMask & whichField))
        _sfTexCoords4.syncWith(pOther->_sfTexCoords4);

    if(FieldBits::NoField != (TexCoords5FieldMask & whichField))
        _sfTexCoords5.syncWith(pOther->_sfTexCoords5);

    if(FieldBits::NoField != (TexCoords6FieldMask & whichField))
        _sfTexCoords6.syncWith(pOther->_sfTexCoords6);

    if(FieldBits::NoField != (TexCoords7FieldMask & whichField))
        _sfTexCoords7.syncWith(pOther->_sfTexCoords7);

    if(FieldBits::NoField != (IndicesFieldMask & whichField))
        _sfIndices.syncWith(pOther->_sfIndices);

    if(FieldBits::NoField != (IndexMappingFieldMask & whichField))
        _mfIndexMapping.syncWith(pOther->_mfIndexMapping);

    if(FieldBits::NoField != (DlistCacheFieldMask & whichField))
        _sfDlistCache.syncWith(pOther->_sfDlistCache);

    if(FieldBits::NoField != (GLIdFieldMask & whichField))
        _sfGLId.syncWith(pOther->_sfGLId);

    if(FieldBits::NoField != (IgnoreGLForAspectFieldMask & whichField))
        _sfIgnoreGLForAspect.syncWith(pOther->_sfIgnoreGLForAspect);

    if(FieldBits::NoField != (MinindexFieldMask & whichField))
        _sfMinindex.syncWith(pOther->_sfMinindex);

    if(FieldBits::NoField != (MaxindexFieldMask & whichField))
        _sfMaxindex.syncWith(pOther->_sfMaxindex);

    if(FieldBits::NoField != (LowindicesFieldMask & whichField))
        _mfLowindices.syncWith(pOther->_mfLowindices);

    if(FieldBits::NoField != (HighindicesFieldMask & whichField))
        _mfHighindices.syncWith(pOther->_mfHighindices);

    if(FieldBits::NoField != (VboFieldMask & whichField))
        _sfVbo.syncWith(pOther->_sfVbo);


}
#else
void GeometryBase::executeSyncImpl(      GeometryBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (TypesFieldMask & whichField))
        _sfTypes.syncWith(pOther->_sfTypes);

    if(FieldBits::NoField != (LengthsFieldMask & whichField))
        _sfLengths.syncWith(pOther->_sfLengths);

    if(FieldBits::NoField != (PositionsFieldMask & whichField))
        _sfPositions.syncWith(pOther->_sfPositions);

    if(FieldBits::NoField != (NormalsFieldMask & whichField))
        _sfNormals.syncWith(pOther->_sfNormals);

    if(FieldBits::NoField != (ColorsFieldMask & whichField))
        _sfColors.syncWith(pOther->_sfColors);

    if(FieldBits::NoField != (SecondaryColorsFieldMask & whichField))
        _sfSecondaryColors.syncWith(pOther->_sfSecondaryColors);

    if(FieldBits::NoField != (TexCoordsFieldMask & whichField))
        _sfTexCoords.syncWith(pOther->_sfTexCoords);

    if(FieldBits::NoField != (TexCoords1FieldMask & whichField))
        _sfTexCoords1.syncWith(pOther->_sfTexCoords1);

    if(FieldBits::NoField != (TexCoords2FieldMask & whichField))
        _sfTexCoords2.syncWith(pOther->_sfTexCoords2);

    if(FieldBits::NoField != (TexCoords3FieldMask & whichField))
        _sfTexCoords3.syncWith(pOther->_sfTexCoords3);

    if(FieldBits::NoField != (TexCoords4FieldMask & whichField))
        _sfTexCoords4.syncWith(pOther->_sfTexCoords4);

    if(FieldBits::NoField != (TexCoords5FieldMask & whichField))
        _sfTexCoords5.syncWith(pOther->_sfTexCoords5);

    if(FieldBits::NoField != (TexCoords6FieldMask & whichField))
        _sfTexCoords6.syncWith(pOther->_sfTexCoords6);

    if(FieldBits::NoField != (TexCoords7FieldMask & whichField))
        _sfTexCoords7.syncWith(pOther->_sfTexCoords7);

    if(FieldBits::NoField != (IndicesFieldMask & whichField))
        _sfIndices.syncWith(pOther->_sfIndices);

    if(FieldBits::NoField != (DlistCacheFieldMask & whichField))
        _sfDlistCache.syncWith(pOther->_sfDlistCache);

    if(FieldBits::NoField != (GLIdFieldMask & whichField))
        _sfGLId.syncWith(pOther->_sfGLId);

    if(FieldBits::NoField != (IgnoreGLForAspectFieldMask & whichField))
        _sfIgnoreGLForAspect.syncWith(pOther->_sfIgnoreGLForAspect);

    if(FieldBits::NoField != (MinindexFieldMask & whichField))
        _sfMinindex.syncWith(pOther->_sfMinindex);

    if(FieldBits::NoField != (MaxindexFieldMask & whichField))
        _sfMaxindex.syncWith(pOther->_sfMaxindex);

    if(FieldBits::NoField != (VboFieldMask & whichField))
        _sfVbo.syncWith(pOther->_sfVbo);


    if(FieldBits::NoField != (IndexMappingFieldMask & whichField))
        _mfIndexMapping.syncWith(pOther->_mfIndexMapping, sInfo);

    if(FieldBits::NoField != (LowindicesFieldMask & whichField))
        _mfLowindices.syncWith(pOther->_mfLowindices, sInfo);

    if(FieldBits::NoField != (HighindicesFieldMask & whichField))
        _mfHighindices.syncWith(pOther->_mfHighindices, sInfo);


}

void GeometryBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

    if(FieldBits::NoField != (IndexMappingFieldMask & whichField))
        _mfIndexMapping.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (LowindicesFieldMask & whichField))
        _mfLowindices.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (HighindicesFieldMask & whichField))
        _mfHighindices.beginEdit(uiAspect, uiContainerSize);

}
#endif



OSG_END_NAMESPACE

#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<GeometryPtr>::_type("GeometryPtr", "MaterialDrawablePtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(GeometryPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(GeometryPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.47 2006/03/17 17:03:19 pdaehne Exp $";
    static Char8 cvsid_hpp       [] = OSGGEOMETRYBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGGEOMETRYBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGGEOMETRYFIELDS_HEADER_CVSID;
}

OSG_END_NAMESPACE

