/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class DVRClipGeometry!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE


//! access the type of the class
inline
OSG::FieldContainerType &DVRClipGeometryBase::getClassType(void)
{
    return _type; 
} 

//! access the numerical type of the class
inline
OSG::UInt32 DVRClipGeometryBase::getClassTypeId(void) 
{
    return _type.getId(); 
} 

//! create a new instance of the class
inline
DVRClipGeometryPtr DVRClipGeometryBase::create(void) 
{
    DVRClipGeometryPtr fc; 

    if(getClassType().getPrototype() != OSG::NullFC) 
    {
        fc = DVRClipGeometryPtr::dcast(
            getClassType().getPrototype()-> shallowCopy()); 
    }
    
    return fc; 
}

//! create an empty new instance of the class, do not copy the prototype
inline
DVRClipGeometryPtr DVRClipGeometryBase::createEmpty(void) 
{ 
    DVRClipGeometryPtr returnValue; 
    
    newPtr(returnValue); 

    return returnValue; 
}


/*------------------------------ get -----------------------------------*/

//! Get the DVRClipGeometry::_sfGeometryNode field.
inline
SFNodePtr *DVRClipGeometryBase::getSFGeometryNode(void)
{
    return &_sfGeometryNode;
}

//! Get the DVRClipGeometry::_sfBeacon field.
inline
SFNodePtr *DVRClipGeometryBase::getSFBeacon(void)
{
    return &_sfBeacon;
}


//! Get the value of the DVRClipGeometry::_sfGeometryNode field.
inline
NodePtr &DVRClipGeometryBase::getGeometryNode(void)
{
    return _sfGeometryNode.getValue();
}

//! Get the value of the DVRClipGeometry::_sfGeometryNode field.
inline
const NodePtr &DVRClipGeometryBase::getGeometryNode(void) const
{
    return _sfGeometryNode.getValue();
}

//! Set the value of the DVRClipGeometry::_sfGeometryNode field.
inline
void DVRClipGeometryBase::setGeometryNode(const NodePtr &value)
{
    _sfGeometryNode.setValue(value);
}

//! Get the value of the DVRClipGeometry::_sfBeacon field.
inline
NodePtr &DVRClipGeometryBase::getBeacon(void)
{
    return _sfBeacon.getValue();
}

//! Get the value of the DVRClipGeometry::_sfBeacon field.
inline
const NodePtr &DVRClipGeometryBase::getBeacon(void) const
{
    return _sfBeacon.getValue();
}

//! Set the value of the DVRClipGeometry::_sfBeacon field.
inline
void DVRClipGeometryBase::setBeacon(const NodePtr &value)
{
    _sfBeacon.setValue(value);
}


OSG_END_NAMESPACE

#define OSGDVRCLIPGEOMETRYBASE_INLINE_CVSID "@(#)$Id: FCBaseTemplate_inl.h,v 1.20 2002/12/04 14:22:22 dirk Exp $"

