/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class DVRClipObjects!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE


//! access the type of the class
inline
OSG::FieldContainerType &DVRClipObjectsBase::getClassType(void)
{
    return _type; 
} 

//! access the numerical type of the class
inline
OSG::UInt32 DVRClipObjectsBase::getClassTypeId(void) 
{
    return _type.getId(); 
} 

//! create a new instance of the class
inline
DVRClipObjectsPtr DVRClipObjectsBase::create(void) 
{
    DVRClipObjectsPtr fc; 

    if(getClassType().getPrototype() != OSG::NullFC) 
    {
        fc = DVRClipObjectsPtr::dcast(
            getClassType().getPrototype()-> shallowCopy()); 
    }
    
    return fc; 
}

//! create an empty new instance of the class, do not copy the prototype
inline
DVRClipObjectsPtr DVRClipObjectsBase::createEmpty(void) 
{ 
    DVRClipObjectsPtr returnValue; 
    
    newPtr(returnValue); 

    return returnValue; 
}


/*------------------------------ get -----------------------------------*/

//! Get the DVRClipObjects::_mfClipObjects field.
inline
MFDVRClipGeometryPtr *DVRClipObjectsBase::getMFClipObjects(void)
{
    return &_mfClipObjects;
}

//! Get the DVRClipObjects::_sfClipMode field.
inline
SFInt32 *DVRClipObjectsBase::getSFClipMode(void)
{
    return &_sfClipMode;
}

//! Get the DVRClipObjects::_sfDoContours field.
inline
SFBool *DVRClipObjectsBase::getSFDoContours(void)
{
    return &_sfDoContours;
}


//! Get the value of the DVRClipObjects::_sfClipMode field.
inline
Int32 &DVRClipObjectsBase::getClipMode(void)
{
    return _sfClipMode.getValue();
}

//! Get the value of the DVRClipObjects::_sfClipMode field.
inline
const Int32 &DVRClipObjectsBase::getClipMode(void) const
{
    return _sfClipMode.getValue();
}

//! Set the value of the DVRClipObjects::_sfClipMode field.
inline
void DVRClipObjectsBase::setClipMode(const Int32 &value)
{
    _sfClipMode.setValue(value);
}

//! Get the value of the DVRClipObjects::_sfDoContours field.
inline
bool &DVRClipObjectsBase::getDoContours(void)
{
    return _sfDoContours.getValue();
}

//! Get the value of the DVRClipObjects::_sfDoContours field.
inline
const bool &DVRClipObjectsBase::getDoContours(void) const
{
    return _sfDoContours.getValue();
}

//! Set the value of the DVRClipObjects::_sfDoContours field.
inline
void DVRClipObjectsBase::setDoContours(const bool &value)
{
    _sfDoContours.setValue(value);
}


//! Get the value of the \a index element the DVRClipObjects::_mfClipObjects field.
inline
DVRClipGeometryPtr &DVRClipObjectsBase::getClipObjects(const UInt32 index)
{
    return _mfClipObjects[index];
}

//! Get the DVRClipObjects::_mfClipObjects field.
inline
MFDVRClipGeometryPtr &DVRClipObjectsBase::getClipObjects(void)
{
    return _mfClipObjects;
}

//! Get the DVRClipObjects::_mfClipObjects field.
inline
const MFDVRClipGeometryPtr &DVRClipObjectsBase::getClipObjects(void) const
{
    return _mfClipObjects;
}

OSG_END_NAMESPACE

#define OSGDVRCLIPOBJECTSBASE_INLINE_CVSID "@(#)$Id: FCBaseTemplate_inl.h,v 1.20 2002/12/04 14:22:22 dirk Exp $"

