/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class SpotLight!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILESPOTLIGHTINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGSpotLightBase.h"
#include "OSGSpotLight.h"


OSG_USING_NAMESPACE

const OSG::BitVector  SpotLightBase::DirectionFieldMask = 
    (TypeTraits<BitVector>::One << SpotLightBase::DirectionFieldId);

const OSG::BitVector  SpotLightBase::SpotExponentFieldMask = 
    (TypeTraits<BitVector>::One << SpotLightBase::SpotExponentFieldId);

const OSG::BitVector  SpotLightBase::SpotCutOffFieldMask = 
    (TypeTraits<BitVector>::One << SpotLightBase::SpotCutOffFieldId);

const OSG::BitVector SpotLightBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var Vec3f           SpotLightBase::_sfDirection
    
*/
/*! \var Real32          SpotLightBase::_sfSpotExponent
    The drop-off exponent of the spotlight.
*/
/*! \var Real32          SpotLightBase::_sfSpotCutOff
    The cut-off angle of the spotlight (in radians, not degrees!).
*/

//! SpotLight description

FieldDescription *SpotLightBase::_desc[] = 
{
    new FieldDescription(SFVec3f::getClassType(), 
                     "direction", 
                     DirectionFieldId, DirectionFieldMask,
                     false,
                     (FieldAccessMethod) &SpotLightBase::getSFDirection),
    new FieldDescription(SFReal32::getClassType(), 
                     "spotExponent", 
                     SpotExponentFieldId, SpotExponentFieldMask,
                     false,
                     (FieldAccessMethod) &SpotLightBase::getSFSpotExponent),
    new FieldDescription(SFReal32::getClassType(), 
                     "spotCutOff", 
                     SpotCutOffFieldId, SpotCutOffFieldMask,
                     false,
                     (FieldAccessMethod) &SpotLightBase::getSFSpotCutOff)
};


FieldContainerType SpotLightBase::_type(
    "SpotLight",
    "PointLight",
    NULL,
    (PrototypeCreateF) &SpotLightBase::createEmpty,
    SpotLight::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(SpotLightBase, SpotLightPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &SpotLightBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &SpotLightBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr SpotLightBase::shallowCopy(void) const 
{ 
    SpotLightPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const SpotLight *>(this)); 

    return returnValue; 
}

UInt32 SpotLightBase::getContainerSize(void) const 
{ 
    return sizeof(SpotLight); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void SpotLightBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((SpotLightBase *) &other, whichField);
}
#else
void SpotLightBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((SpotLightBase *) &other, whichField, sInfo);
}
void SpotLightBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void SpotLightBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

SpotLightBase::SpotLightBase(void) :
    _sfDirection              (Vec3f(0,0,1)), 
    _sfSpotExponent           (), 
    _sfSpotCutOff             (), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

SpotLightBase::SpotLightBase(const SpotLightBase &source) :
    _sfDirection              (source._sfDirection              ), 
    _sfSpotExponent           (source._sfSpotExponent           ), 
    _sfSpotCutOff             (source._sfSpotCutOff             ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

SpotLightBase::~SpotLightBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 SpotLightBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (DirectionFieldMask & whichField))
    {
        returnValue += _sfDirection.getBinSize();
    }

    if(FieldBits::NoField != (SpotExponentFieldMask & whichField))
    {
        returnValue += _sfSpotExponent.getBinSize();
    }

    if(FieldBits::NoField != (SpotCutOffFieldMask & whichField))
    {
        returnValue += _sfSpotCutOff.getBinSize();
    }


    return returnValue;
}

void SpotLightBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (DirectionFieldMask & whichField))
    {
        _sfDirection.copyToBin(pMem);
    }

    if(FieldBits::NoField != (SpotExponentFieldMask & whichField))
    {
        _sfSpotExponent.copyToBin(pMem);
    }

    if(FieldBits::NoField != (SpotCutOffFieldMask & whichField))
    {
        _sfSpotCutOff.copyToBin(pMem);
    }


}

void SpotLightBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (DirectionFieldMask & whichField))
    {
        _sfDirection.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (SpotExponentFieldMask & whichField))
    {
        _sfSpotExponent.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (SpotCutOffFieldMask & whichField))
    {
        _sfSpotCutOff.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void SpotLightBase::executeSyncImpl(      SpotLightBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (DirectionFieldMask & whichField))
        _sfDirection.syncWith(pOther->_sfDirection);

    if(FieldBits::NoField != (SpotExponentFieldMask & whichField))
        _sfSpotExponent.syncWith(pOther->_sfSpotExponent);

    if(FieldBits::NoField != (SpotCutOffFieldMask & whichField))
        _sfSpotCutOff.syncWith(pOther->_sfSpotCutOff);


}
#else
void SpotLightBase::executeSyncImpl(      SpotLightBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (DirectionFieldMask & whichField))
        _sfDirection.syncWith(pOther->_sfDirection);

    if(FieldBits::NoField != (SpotExponentFieldMask & whichField))
        _sfSpotExponent.syncWith(pOther->_sfSpotExponent);

    if(FieldBits::NoField != (SpotCutOffFieldMask & whichField))
        _sfSpotCutOff.syncWith(pOther->_sfSpotCutOff);



}

void SpotLightBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<SpotLightPtr>::_type("SpotLightPtr", "PointLightPtr");
#endif


OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.45 2005/07/20 00:10:14 vossg Exp $";
    static Char8 cvsid_hpp       [] = OSGSPOTLIGHTBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGSPOTLIGHTBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGSPOTLIGHTFIELDS_HEADER_CVSID;
}

