/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class SpotLight!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE


//! access the type of the class
inline
OSG::FieldContainerType &SpotLightBase::getClassType(void)
{
    return _type; 
} 

//! access the numerical type of the class
inline
OSG::UInt32 SpotLightBase::getClassTypeId(void) 
{
    return _type.getId(); 
} 

//! create a new instance of the class
inline
SpotLightPtr SpotLightBase::create(void) 
{
    SpotLightPtr fc; 

    if(getClassType().getPrototype() != OSG::NullFC) 
    {
        fc = SpotLightPtr::dcast(
            getClassType().getPrototype()-> shallowCopy()); 
    }
    
    return fc; 
}

//! create an empty new instance of the class, do not copy the prototype
inline
SpotLightPtr SpotLightBase::createEmpty(void) 
{ 
    SpotLightPtr returnValue; 
    
    newPtr(returnValue); 

    return returnValue; 
}


/*------------------------------ get -----------------------------------*/

//! Get the SpotLight::_sfDirection field.
inline
SFVec3f *SpotLightBase::getSFDirection(void)
{
    return &_sfDirection;
}

//! Get the SpotLight::_sfSpotExponent field.
inline
SFReal32 *SpotLightBase::getSFSpotExponent(void)
{
    return &_sfSpotExponent;
}

//! Get the SpotLight::_sfSpotCutOff field.
inline
SFReal32 *SpotLightBase::getSFSpotCutOff(void)
{
    return &_sfSpotCutOff;
}


//! Get the value of the SpotLight::_sfDirection field.
inline
Vec3f &SpotLightBase::getDirection(void)
{
    return _sfDirection.getValue();
}

//! Get the value of the SpotLight::_sfDirection field.
inline
const Vec3f &SpotLightBase::getDirection(void) const
{
    return _sfDirection.getValue();
}

//! Set the value of the SpotLight::_sfDirection field.
inline
void SpotLightBase::setDirection(const Vec3f &value)
{
    _sfDirection.setValue(value);
}

//! Get the value of the SpotLight::_sfSpotExponent field.
inline
Real32 &SpotLightBase::getSpotExponent(void)
{
    return _sfSpotExponent.getValue();
}

//! Get the value of the SpotLight::_sfSpotExponent field.
inline
const Real32 &SpotLightBase::getSpotExponent(void) const
{
    return _sfSpotExponent.getValue();
}

//! Set the value of the SpotLight::_sfSpotExponent field.
inline
void SpotLightBase::setSpotExponent(const Real32 &value)
{
    _sfSpotExponent.setValue(value);
}

//! Get the value of the SpotLight::_sfSpotCutOff field.
inline
Real32 &SpotLightBase::getSpotCutOff(void)
{
    return _sfSpotCutOff.getValue();
}

//! Get the value of the SpotLight::_sfSpotCutOff field.
inline
const Real32 &SpotLightBase::getSpotCutOff(void) const
{
    return _sfSpotCutOff.getValue();
}

//! Set the value of the SpotLight::_sfSpotCutOff field.
inline
void SpotLightBase::setSpotCutOff(const Real32 &value)
{
    _sfSpotCutOff.setValue(value);
}


OSG_END_NAMESPACE

#define OSGSPOTLIGHTBASE_INLINE_CVSID "@(#)$Id: FCBaseTemplate_inl.h,v 1.20 2002/12/04 14:22:22 dirk Exp $"

