/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class ClipPlane!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILECLIPPLANEINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGClipPlaneBase.h"
#include "OSGClipPlane.h"


OSG_BEGIN_NAMESPACE

const OSG::BitVector  ClipPlaneBase::EquationFieldMask = 
    (TypeTraits<BitVector>::One << ClipPlaneBase::EquationFieldId);

const OSG::BitVector  ClipPlaneBase::OnFieldMask = 
    (TypeTraits<BitVector>::One << ClipPlaneBase::OnFieldId);

const OSG::BitVector  ClipPlaneBase::BeaconFieldMask = 
    (TypeTraits<BitVector>::One << ClipPlaneBase::BeaconFieldId);

const OSG::BitVector ClipPlaneBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var Vec4f           ClipPlaneBase::_sfEquation
    Defines the equation of the clip plane. Standard format, if (a,b,c,d) is         the plane a point (x,y,z) is visible if a*x+b*y+c*z+d &gt;= 0.
*/
/*! \var bool            ClipPlaneBase::_sfOn
    Defines activation state of the clip plane.
*/
/*! \var NodePtr         ClipPlaneBase::_sfBeacon
    The object that defines the clip planes's coordinate system. The clip         plane is positioned relative to this system.
*/

//! ClipPlane description

FieldDescription *ClipPlaneBase::_desc[] = 
{
    new FieldDescription(SFVec4f::getClassType(), 
                     "equation", 
                     EquationFieldId, EquationFieldMask,
                     false,
                     (FieldAccessMethod) &ClipPlaneBase::getSFEquation),
    new FieldDescription(SFBool::getClassType(), 
                     "on", 
                     OnFieldId, OnFieldMask,
                     false,
                     (FieldAccessMethod) &ClipPlaneBase::getSFOn),
    new FieldDescription(SFNodePtr::getClassType(), 
                     "beacon", 
                     BeaconFieldId, BeaconFieldMask,
                     false,
                     (FieldAccessMethod) &ClipPlaneBase::getSFBeacon)
};


FieldContainerType ClipPlaneBase::_type(
    "ClipPlane",
    "Group",
    NULL,
    (PrototypeCreateF) &ClipPlaneBase::createEmpty,
    ClipPlane::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(ClipPlaneBase, ClipPlanePtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &ClipPlaneBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &ClipPlaneBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr ClipPlaneBase::shallowCopy(void) const 
{ 
    ClipPlanePtr returnValue; 

    newPtr(returnValue, dynamic_cast<const ClipPlane *>(this)); 

    return returnValue; 
}

UInt32 ClipPlaneBase::getContainerSize(void) const 
{ 
    return sizeof(ClipPlane); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void ClipPlaneBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((ClipPlaneBase *) &other, whichField);
}
#else
void ClipPlaneBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((ClipPlaneBase *) &other, whichField, sInfo);
}
void ClipPlaneBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void ClipPlaneBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

ClipPlaneBase::ClipPlaneBase(void) :
    _sfEquation               (Vec4f(0, 0, 1, 0)), 
    _sfOn                     (bool(true)), 
    _sfBeacon                 (NodePtr(NullFC)), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

ClipPlaneBase::ClipPlaneBase(const ClipPlaneBase &source) :
    _sfEquation               (source._sfEquation               ), 
    _sfOn                     (source._sfOn                     ), 
    _sfBeacon                 (source._sfBeacon                 ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

ClipPlaneBase::~ClipPlaneBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 ClipPlaneBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (EquationFieldMask & whichField))
    {
        returnValue += _sfEquation.getBinSize();
    }

    if(FieldBits::NoField != (OnFieldMask & whichField))
    {
        returnValue += _sfOn.getBinSize();
    }

    if(FieldBits::NoField != (BeaconFieldMask & whichField))
    {
        returnValue += _sfBeacon.getBinSize();
    }


    return returnValue;
}

void ClipPlaneBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (EquationFieldMask & whichField))
    {
        _sfEquation.copyToBin(pMem);
    }

    if(FieldBits::NoField != (OnFieldMask & whichField))
    {
        _sfOn.copyToBin(pMem);
    }

    if(FieldBits::NoField != (BeaconFieldMask & whichField))
    {
        _sfBeacon.copyToBin(pMem);
    }


}

void ClipPlaneBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (EquationFieldMask & whichField))
    {
        _sfEquation.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (OnFieldMask & whichField))
    {
        _sfOn.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (BeaconFieldMask & whichField))
    {
        _sfBeacon.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void ClipPlaneBase::executeSyncImpl(      ClipPlaneBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (EquationFieldMask & whichField))
        _sfEquation.syncWith(pOther->_sfEquation);

    if(FieldBits::NoField != (OnFieldMask & whichField))
        _sfOn.syncWith(pOther->_sfOn);

    if(FieldBits::NoField != (BeaconFieldMask & whichField))
        _sfBeacon.syncWith(pOther->_sfBeacon);


}
#else
void ClipPlaneBase::executeSyncImpl(      ClipPlaneBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (EquationFieldMask & whichField))
        _sfEquation.syncWith(pOther->_sfEquation);

    if(FieldBits::NoField != (OnFieldMask & whichField))
        _sfOn.syncWith(pOther->_sfOn);

    if(FieldBits::NoField != (BeaconFieldMask & whichField))
        _sfBeacon.syncWith(pOther->_sfBeacon);



}

void ClipPlaneBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



OSG_END_NAMESPACE

#include <OSGSFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<ClipPlanePtr>::_type("ClipPlanePtr", "GroupPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(ClipPlanePtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: OSGClipPlaneBase.cpp,v 1.1 2007/04/26 15:22:01 a-m-z Exp $";
    static Char8 cvsid_hpp       [] = OSGCLIPPLANEBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGCLIPPLANEBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGCLIPPLANEFIELDS_HEADER_CVSID;
}

OSG_END_NAMESPACE

