/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class CameraDecorator!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILECAMERADECORATORINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGCameraDecoratorBase.h"
#include "OSGCameraDecorator.h"


OSG_USING_NAMESPACE

const OSG::BitVector  CameraDecoratorBase::DecorateeFieldMask = 
    (TypeTraits<BitVector>::One << CameraDecoratorBase::DecorateeFieldId);
const OSG::BitVector CameraDecoratorBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 

// Field descriptions

/*! \var CameraPtr CameraDecoratorBase::_sfDecoratee
    The object being decorated
*/

//! CameraDecorator description

FieldDescription *CameraDecoratorBase::_desc[] = 
{
    new FieldDescription(SFCameraPtr::getClassType(), 
                     "decoratee", 
                     DecorateeFieldId, DecorateeFieldMask,
                     true,
                     (FieldAccessMethod) &CameraDecoratorBase::getSFDecoratee)
};


FieldContainerType CameraDecoratorBase::_type(
    "CameraDecorator",
    "Camera",
    NULL,
    NULL, 
    CameraDecorator::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(CameraDecoratorBase, CameraDecoratorPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &CameraDecoratorBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &CameraDecoratorBase::getType(void) const 
{
    return _type;
} 


UInt32 CameraDecoratorBase::getContainerSize(void) const 
{ 
    return sizeof(CameraDecorator); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void CameraDecoratorBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((CameraDecoratorBase *) &other, whichField);
}
#else
void CameraDecoratorBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((CameraDecoratorBase *) &other, whichField, sInfo);
}
void CameraDecoratorBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void CameraDecoratorBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

CameraDecoratorBase::CameraDecoratorBase(void) :
    _sfDecoratee(),
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

CameraDecoratorBase::CameraDecoratorBase(const CameraDecoratorBase &source) :
    _sfDecoratee(source._sfDecoratee),
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

CameraDecoratorBase::~CameraDecoratorBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 CameraDecoratorBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (DecorateeFieldMask & whichField))
    {
        returnValue += _sfDecoratee.getBinSize();
    }

    return returnValue;
}

void CameraDecoratorBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (DecorateeFieldMask & whichField))
    {
        _sfDecoratee.copyToBin(pMem);
    }

}

void CameraDecoratorBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (DecorateeFieldMask & whichField))
    {
        _sfDecoratee.copyFromBin(pMem);
    }

}

#if !defined(OSG_FIXED_MFIELDSYNC)
void CameraDecoratorBase::executeSyncImpl(      CameraDecoratorBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (DecorateeFieldMask & whichField))
    {
        _sfDecoratee.syncWith(pOther->_sfDecoratee);
    }

}
#else
void CameraDecoratorBase::executeSyncImpl(      CameraDecoratorBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (DecorateeFieldMask & whichField))
    {
        _sfDecoratee.syncWith(pOther->_sfDecoratee);
    }

}

void CameraDecoratorBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<CameraDecoratorPtr>::_type("CameraDecoratorPtr", "CameraPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(CameraDecoratorPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(CameraDecoratorPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.45 2005/07/20 00:10:14 vossg Exp $";
    static Char8 cvsid_hpp       [] = OSGCAMERADECORATORBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGCAMERADECORATORBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGCAMERADECORATORFIELDS_HEADER_CVSID;
}

