/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class DistortionDisplayFilter!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEDISTORTIONDISPLAYFILTERINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGDistortionDisplayFilterBase.h"
#include "OSGDistortionDisplayFilter.h"


OSG_BEGIN_NAMESPACE

const OSG::BitVector  DistortionDisplayFilterBase::RowsFieldMask = 
    (TypeTraits<BitVector>::One << DistortionDisplayFilterBase::RowsFieldId);

const OSG::BitVector  DistortionDisplayFilterBase::ColumnsFieldMask = 
    (TypeTraits<BitVector>::One << DistortionDisplayFilterBase::ColumnsFieldId);

const OSG::BitVector  DistortionDisplayFilterBase::PositionsFieldMask = 
    (TypeTraits<BitVector>::One << DistortionDisplayFilterBase::PositionsFieldId);

const OSG::BitVector DistortionDisplayFilterBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var UInt32          DistortionDisplayFilterBase::_sfRows
    
*/
/*! \var UInt32          DistortionDisplayFilterBase::_sfColumns
    
*/
/*! \var Vec2f           DistortionDisplayFilterBase::_mfPositions
    
*/

//! DistortionDisplayFilter description

FieldDescription *DistortionDisplayFilterBase::_desc[] = 
{
    new FieldDescription(SFUInt32::getClassType(), 
                     "rows", 
                     RowsFieldId, RowsFieldMask,
                     false,
                     (FieldAccessMethod) &DistortionDisplayFilterBase::getSFRows),
    new FieldDescription(SFUInt32::getClassType(), 
                     "columns", 
                     ColumnsFieldId, ColumnsFieldMask,
                     false,
                     (FieldAccessMethod) &DistortionDisplayFilterBase::getSFColumns),
    new FieldDescription(MFVec2f::getClassType(), 
                     "positions", 
                     PositionsFieldId, PositionsFieldMask,
                     false,
                     (FieldAccessMethod) &DistortionDisplayFilterBase::getMFPositions)
};


FieldContainerType DistortionDisplayFilterBase::_type(
    "DistortionDisplayFilter",
    "DisplayFilter",
    NULL,
    (PrototypeCreateF) &DistortionDisplayFilterBase::createEmpty,
    DistortionDisplayFilter::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(DistortionDisplayFilterBase, DistortionDisplayFilterPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &DistortionDisplayFilterBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &DistortionDisplayFilterBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr DistortionDisplayFilterBase::shallowCopy(void) const 
{ 
    DistortionDisplayFilterPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const DistortionDisplayFilter *>(this)); 

    return returnValue; 
}

UInt32 DistortionDisplayFilterBase::getContainerSize(void) const 
{ 
    return sizeof(DistortionDisplayFilter); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void DistortionDisplayFilterBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((DistortionDisplayFilterBase *) &other, whichField);
}
#else
void DistortionDisplayFilterBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((DistortionDisplayFilterBase *) &other, whichField, sInfo);
}
void DistortionDisplayFilterBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void DistortionDisplayFilterBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

    _mfPositions.terminateShare(uiAspect, this->getContainerSize());
}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

DistortionDisplayFilterBase::DistortionDisplayFilterBase(void) :
    _sfRows                   (), 
    _sfColumns                (), 
    _mfPositions              (), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

DistortionDisplayFilterBase::DistortionDisplayFilterBase(const DistortionDisplayFilterBase &source) :
    _sfRows                   (source._sfRows                   ), 
    _sfColumns                (source._sfColumns                ), 
    _mfPositions              (source._mfPositions              ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

DistortionDisplayFilterBase::~DistortionDisplayFilterBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 DistortionDisplayFilterBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (RowsFieldMask & whichField))
    {
        returnValue += _sfRows.getBinSize();
    }

    if(FieldBits::NoField != (ColumnsFieldMask & whichField))
    {
        returnValue += _sfColumns.getBinSize();
    }

    if(FieldBits::NoField != (PositionsFieldMask & whichField))
    {
        returnValue += _mfPositions.getBinSize();
    }


    return returnValue;
}

void DistortionDisplayFilterBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (RowsFieldMask & whichField))
    {
        _sfRows.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ColumnsFieldMask & whichField))
    {
        _sfColumns.copyToBin(pMem);
    }

    if(FieldBits::NoField != (PositionsFieldMask & whichField))
    {
        _mfPositions.copyToBin(pMem);
    }


}

void DistortionDisplayFilterBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (RowsFieldMask & whichField))
    {
        _sfRows.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ColumnsFieldMask & whichField))
    {
        _sfColumns.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (PositionsFieldMask & whichField))
    {
        _mfPositions.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void DistortionDisplayFilterBase::executeSyncImpl(      DistortionDisplayFilterBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (RowsFieldMask & whichField))
        _sfRows.syncWith(pOther->_sfRows);

    if(FieldBits::NoField != (ColumnsFieldMask & whichField))
        _sfColumns.syncWith(pOther->_sfColumns);

    if(FieldBits::NoField != (PositionsFieldMask & whichField))
        _mfPositions.syncWith(pOther->_mfPositions);


}
#else
void DistortionDisplayFilterBase::executeSyncImpl(      DistortionDisplayFilterBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (RowsFieldMask & whichField))
        _sfRows.syncWith(pOther->_sfRows);

    if(FieldBits::NoField != (ColumnsFieldMask & whichField))
        _sfColumns.syncWith(pOther->_sfColumns);


    if(FieldBits::NoField != (PositionsFieldMask & whichField))
        _mfPositions.syncWith(pOther->_mfPositions, sInfo);


}

void DistortionDisplayFilterBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

    if(FieldBits::NoField != (PositionsFieldMask & whichField))
        _mfPositions.beginEdit(uiAspect, uiContainerSize);

}
#endif



OSG_END_NAMESPACE

#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<DistortionDisplayFilterPtr>::_type("DistortionDisplayFilterPtr", "DisplayFilterPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(DistortionDisplayFilterPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(DistortionDisplayFilterPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.46 2006/03/16 17:01:53 dirk Exp $";
    static Char8 cvsid_hpp       [] = OSGDISTORTIONDISPLAYFILTERBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGDISTORTIONDISPLAYFILTERBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGDISTORTIONDISPLAYFILTERFIELDS_HEADER_CVSID;
}

OSG_END_NAMESPACE

