/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class FileGrabForeground!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEFILEGRABFOREGROUNDINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGFileGrabForegroundBase.h"
#include "OSGFileGrabForeground.h"


OSG_USING_NAMESPACE

const OSG::BitVector  FileGrabForegroundBase::NameFieldMask = 
    (TypeTraits<BitVector>::One << FileGrabForegroundBase::NameFieldId);

const OSG::BitVector  FileGrabForegroundBase::FrameFieldMask = 
    (TypeTraits<BitVector>::One << FileGrabForegroundBase::FrameFieldId);

const OSG::BitVector  FileGrabForegroundBase::IncrementFieldMask = 
    (TypeTraits<BitVector>::One << FileGrabForegroundBase::IncrementFieldId);

const OSG::BitVector FileGrabForegroundBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var std::string     FileGrabForegroundBase::_sfName
    The filename template. %d is replaced by the frame number.
*/
/*! \var UInt32          FileGrabForegroundBase::_sfFrame
    The frame number to use.
*/
/*! \var bool            FileGrabForegroundBase::_sfIncrement
    Flag to start/stop automatic frame increments after each grab.
*/

//! FileGrabForeground description

FieldDescription *FileGrabForegroundBase::_desc[] = 
{
    new FieldDescription(SFString::getClassType(), 
                     "name", 
                     NameFieldId, NameFieldMask,
                     false,
                     (FieldAccessMethod) &FileGrabForegroundBase::getSFName),
    new FieldDescription(SFUInt32::getClassType(), 
                     "frame", 
                     FrameFieldId, FrameFieldMask,
                     false,
                     (FieldAccessMethod) &FileGrabForegroundBase::getSFFrame),
    new FieldDescription(SFBool::getClassType(), 
                     "increment", 
                     IncrementFieldId, IncrementFieldMask,
                     false,
                     (FieldAccessMethod) &FileGrabForegroundBase::getSFIncrement)
};


FieldContainerType FileGrabForegroundBase::_type(
    "FileGrabForeground",
    "GrabForeground",
    NULL,
    (PrototypeCreateF) &FileGrabForegroundBase::createEmpty,
    FileGrabForeground::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(FileGrabForegroundBase, FileGrabForegroundPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &FileGrabForegroundBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &FileGrabForegroundBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr FileGrabForegroundBase::shallowCopy(void) const 
{ 
    FileGrabForegroundPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const FileGrabForeground *>(this)); 

    return returnValue; 
}

UInt32 FileGrabForegroundBase::getContainerSize(void) const 
{ 
    return sizeof(FileGrabForeground); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void FileGrabForegroundBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((FileGrabForegroundBase *) &other, whichField);
}
#else
void FileGrabForegroundBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((FileGrabForegroundBase *) &other, whichField, sInfo);
}
void FileGrabForegroundBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void FileGrabForegroundBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

FileGrabForegroundBase::FileGrabForegroundBase(void) :
    _sfName                   (), 
    _sfFrame                  (UInt32(0)), 
    _sfIncrement              (bool(true)), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

FileGrabForegroundBase::FileGrabForegroundBase(const FileGrabForegroundBase &source) :
    _sfName                   (source._sfName                   ), 
    _sfFrame                  (source._sfFrame                  ), 
    _sfIncrement              (source._sfIncrement              ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

FileGrabForegroundBase::~FileGrabForegroundBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 FileGrabForegroundBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (NameFieldMask & whichField))
    {
        returnValue += _sfName.getBinSize();
    }

    if(FieldBits::NoField != (FrameFieldMask & whichField))
    {
        returnValue += _sfFrame.getBinSize();
    }

    if(FieldBits::NoField != (IncrementFieldMask & whichField))
    {
        returnValue += _sfIncrement.getBinSize();
    }


    return returnValue;
}

void FileGrabForegroundBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (NameFieldMask & whichField))
    {
        _sfName.copyToBin(pMem);
    }

    if(FieldBits::NoField != (FrameFieldMask & whichField))
    {
        _sfFrame.copyToBin(pMem);
    }

    if(FieldBits::NoField != (IncrementFieldMask & whichField))
    {
        _sfIncrement.copyToBin(pMem);
    }


}

void FileGrabForegroundBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (NameFieldMask & whichField))
    {
        _sfName.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (FrameFieldMask & whichField))
    {
        _sfFrame.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (IncrementFieldMask & whichField))
    {
        _sfIncrement.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void FileGrabForegroundBase::executeSyncImpl(      FileGrabForegroundBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (NameFieldMask & whichField))
        _sfName.syncWith(pOther->_sfName);

    if(FieldBits::NoField != (FrameFieldMask & whichField))
        _sfFrame.syncWith(pOther->_sfFrame);

    if(FieldBits::NoField != (IncrementFieldMask & whichField))
        _sfIncrement.syncWith(pOther->_sfIncrement);


}
#else
void FileGrabForegroundBase::executeSyncImpl(      FileGrabForegroundBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (NameFieldMask & whichField))
        _sfName.syncWith(pOther->_sfName);

    if(FieldBits::NoField != (FrameFieldMask & whichField))
        _sfFrame.syncWith(pOther->_sfFrame);

    if(FieldBits::NoField != (IncrementFieldMask & whichField))
        _sfIncrement.syncWith(pOther->_sfIncrement);



}

void FileGrabForegroundBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<FileGrabForegroundPtr>::_type("FileGrabForegroundPtr", "GrabForegroundPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(FileGrabForegroundPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(FileGrabForegroundPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.45 2005/07/20 00:10:14 vossg Exp $";
    static Char8 cvsid_hpp       [] = OSGFILEGRABFOREGROUNDBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGFILEGRABFOREGROUNDBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGFILEGRABFOREGROUNDFIELDS_HEADER_CVSID;
}

