/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class CoreGLWindow!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILECOREGLWINDOWINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGCoreGLWindowBase.h"
#include "OSGCoreGLWindow.h"


OSG_BEGIN_NAMESPACE

const OSG::BitVector  CoreGLWindowBase::ContextFieldMask = 
    (TypeTraits<BitVector>::One << CoreGLWindowBase::ContextFieldId);

const OSG::BitVector CoreGLWindowBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var CGLContextObj   CoreGLWindowBase::_sfContext
    
*/

//! CoreGLWindow description

FieldDescription *CoreGLWindowBase::_desc[] = 
{
    new FieldDescription(SFCGLContextObj::getClassType(), 
                     "context", 
                     ContextFieldId, ContextFieldMask,
                     true,
                     (FieldAccessMethod) &CoreGLWindowBase::getSFContext)
};


FieldContainerType CoreGLWindowBase::_type(
    "CoreGLWindow",
    "Window",
    NULL,
    (PrototypeCreateF) &CoreGLWindowBase::createEmpty,
    CoreGLWindow::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(CoreGLWindowBase, CoreGLWindowPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &CoreGLWindowBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &CoreGLWindowBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr CoreGLWindowBase::shallowCopy(void) const 
{ 
    CoreGLWindowPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const CoreGLWindow *>(this)); 

    return returnValue; 
}

UInt32 CoreGLWindowBase::getContainerSize(void) const 
{ 
    return sizeof(CoreGLWindow); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void CoreGLWindowBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((CoreGLWindowBase *) &other, whichField);
}
#else
void CoreGLWindowBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((CoreGLWindowBase *) &other, whichField, sInfo);
}
void CoreGLWindowBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void CoreGLWindowBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

CoreGLWindowBase::CoreGLWindowBase(void) :
    _sfContext                (CGLContextObj(0)), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

CoreGLWindowBase::CoreGLWindowBase(const CoreGLWindowBase &source) :
    _sfContext                (source._sfContext                ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

CoreGLWindowBase::~CoreGLWindowBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 CoreGLWindowBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (ContextFieldMask & whichField))
    {
        returnValue += _sfContext.getBinSize();
    }


    return returnValue;
}

void CoreGLWindowBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (ContextFieldMask & whichField))
    {
        _sfContext.copyToBin(pMem);
    }


}

void CoreGLWindowBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (ContextFieldMask & whichField))
    {
        _sfContext.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void CoreGLWindowBase::executeSyncImpl(      CoreGLWindowBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (ContextFieldMask & whichField))
        _sfContext.syncWith(pOther->_sfContext);


}
#else
void CoreGLWindowBase::executeSyncImpl(      CoreGLWindowBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (ContextFieldMask & whichField))
        _sfContext.syncWith(pOther->_sfContext);



}

void CoreGLWindowBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



OSG_END_NAMESPACE

#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<CoreGLWindowPtr>::_type("CoreGLWindowPtr", "WindowPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(CoreGLWindowPtr, OSG_WINDOWCOREGLLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(CoreGLWindowPtr, OSG_WINDOWCOREGLLIB_DLLTMPLMAPPING);


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: OSGCoreGLWindowBase.cpp,v 1.1 2006/09/08 10:09:06 pdaehne Exp $";
    static Char8 cvsid_hpp       [] = OSGCOREGLWINDOWBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGCOREGLWINDOWBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGCOREGLWINDOWFIELDS_HEADER_CVSID;
}

OSG_END_NAMESPACE

