#!/usr/bin/perl
package OpenSRS::Catcher;
use strict;

use Exporter;
use vars  qw ( @ISA @EXPORT );
@ISA    = qw ( Exporter );
@EXPORT = qw ( try  catch );

use vars '$E'; # semi-global variable which will holds exceptions when
# they're thrown.


#use OpenSRS::Catcher;
#
#try { 
#   print "in try\n"; 
#   throw Err "ErrorState",{q=>1,e=>2,r=>3};
#   die "crazi fish\n";
# } catch {
# 	_final        => sub { my $Er = shift; print "finally\n";},
#       ErrorState    => sub { my $Er = shift; print "Catcher\n";},
#	_other        => sub { my $Er = shift; print "otherwise\n";},
#       qr/DBI/is     => sub { my $Er = shift; print "DBI Error",$Er->info,"\n";},
#        }
#;	


sub try (&$) {
    my($try, $catchers) = @_;
    # Try the code. 
    eval {
	#clean old error message
	undef $E;
	local($SIG{'__DIE__'});
	&$try()
	};
    if (exists $catchers->{'_final'}) {
	my $finally = $catchers->{'_final'};
	&$finally();
    }
    my $_error=$@;
    if ($_error) {
	my $lE = $E||new Exception $_error;
	undef $E;
	my $catcher=$catchers->{$lE->name} if defined $lE->name;
        unless (defined $catcher) {
            my @all_catchers = keys %$catchers;
            # Check all regexp rules
            foreach (grep /^\(\?/, @all_catchers){
                next unless $_error =~ /$_/;
                $catcher = $catchers->{$_};
                last;
            }
        };
	
	$catcher||=$catchers->{'_other'};
	throw $lE if not defined $catcher;
	&$catcher($lE);
    } #if
}

sub catch ($) { shift; }

package Exception;
use Data::Dumper;
use vars qw($AUTOLOAD);
use Carp;

my %fields = (
	      callstack   => undef,
	      name        => undef,
	      info        => undef
	      );

sub new {
    my $class  = shift;
    $class = ref($class) || $class;
    my $name=shift;
    $name||="Native";
    $fields{'name'}=$name;
    $fields{'info'}=shift;
    {
	my $i=0;
	my $callstack;
	my ($pkg, $file, $line);
	while (($pkg, $file, $line)=caller($i++)) {
	    $callstack.="\n[$$ module:$pkg,file:$file,line:$line] ";
	} 
	$fields{'callstack'}=$callstack;
    }
    my $self  = {
        %fields,
    };
    bless $self, $class;
    return $self;
} 

sub DESTROY{
}

sub AUTOLOAD {
    my $self = shift;
    my $type = ref($self) || croak "$self is not an object";
    my $name = $AUTOLOAD;
    $name =~ s/.*://;   # strip fully-qualified portion
    unless (exists $self->{$name} ) {
        croak "There is no such `$name' field in object of class $type";
    } 
    return $self->{$name};
}

sub dump {
    my $self=shift;
    my $dump="Exception:".$self->name."\n CallStack ".$self->callstack."\n".
	($self->info?Dumper($self->info):"");
}

sub throw {
    my ($class_or_self, @args) = @_;
    my $class;
    if ($class = ref $class_or_self) {
	$OpenSRS::Catcher::E = $class_or_self;
    } else {
	$class = $class_or_self;
	$OpenSRS::Catcher::E = $class->new(@args);
    }
    die $OpenSRS::Catcher::E->dump;
}
