//                                               -*- C++ -*-
/**
 * @file		AnalyticalFunction.cxx
 * @brief		Store information about an analytical function
 *
 * @author	Romuald Conty
 * @date		2006-07-10 12:00:33
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "AnalyticalFunction.hxx"

// OT::UI::GUI
#include "Parameter.hxx"
#include "FunctionParametersProperty.hxx"

// std
#include <iostream>

// Qt
#include <qdir.h>

// OT::UI::GUI
#include "DescriptionProperty.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			/** Default constructor */
			AnalyticalFunction::AnalyticalFunction ( QOTObject * parent, const char * name ) : Function ( parent, name )
			{
				new FunctionParametersProperty ( &inputs_, true, this, "inputs" );

				output_ = Description ( 1 );
				new DescriptionProperty ( &output_, 0, true, this, "output" );

				formula_ = Description ( 1 );
				new DescriptionProperty ( &formula_, 0, true, this, "formula" );
			}

			/** Copy constructor */
			AnalyticalFunction::AnalyticalFunction ( const AnalyticalFunction & other, QOTObject* parent ) : Function ( parent )
			{
				assignToMe ( other );
			}

			/** Destructor */
			AnalyticalFunction::~AnalyticalFunction()
			{}

			/** AnalyticalFunction result name accessor */
			void AnalyticalFunction::setOutput ( const QString& output )
			{
				output_[ 0 ] = output.ascii();
			}

			/** AnalyticalFunction result name accessor */
			QString AnalyticalFunction::getOutput() const
			{
				return QString ( output_[ 0 ] );
			}

			/** AnalyticalFunction formula accessor */
			void AnalyticalFunction::setFormula ( QString formula )
			{
				formula = formula.stripWhiteSpace();
				if ( formula != QString ( formula_[ 0 ] ) )
				{
					formula_[ 0 ] = formula.ascii();
				}
			}

			/** AnalyticalFunction formula accessor */
			QString AnalyticalFunction::getFormula() const
			{
				return QString ( formula_[ 0 ] );
			}

			/** The function that actually realizes assignment between objects */
			void AnalyticalFunction::assignToMe ( const AnalyticalFunction & other )
			{
				Function::assignToMe ( other );
				setOutput ( other.getOutput() );
				setFormula ( other.getFormula() );
			}

			NumericalMathFunction AnalyticalFunction::getNumericalMathFunction()
			{
				return NumericalMathFunction ( inputs_, output_, formula_ );
			}

		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */
