//                                               -*- C++ -*-
/**
 * @file		Block.cxx
 * @brief		Generalization of Block*
 *
 * @author		Romuald Conty
 * @date			2006-06-12
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

// Header
#include "Block.hxx"

// OT::UI::GUI
#include "QOTAction.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			/** Default constructor */
			Block::Block ( QOTObject * parent, const char* name ) : QOTObject ( parent, name )
			{
				//QOTAction * actionView = new QOTAction( tr("View this object"), 0, this, "Block_view");
				QOTAction * actionRemove = new QOTAction ( tr ( "Delete this object" ), 0, this, "Block_deleteObject" );
				connect ( actionRemove, SIGNAL ( activated() ), this, SLOT ( destroy() ) );
				setRenameEnabled ( true );
			}

			/** Destructor */
			Block::~Block()
			{}

			void Block::destroy()
			{
				delete this;
			}

			void Block::getQOTObjects ( QObjectList* objectList )
			{
				getChildren ( objectList, "OpenTURNS::UI::GUI::QOTObject", TRUE );
			}

			QString Block::getFullName() const
			{
				return getName();
				//			return getType() + " : " + getName();
			}

			void Block::setType ( const QString& type )
			{
				type_ = type;
			}

			QString Block::getType() const
			{
				return type_;
			}
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

