//                                               -*- C++ -*-
/**
 * @file		Block.hxx
 * @brief		Generalization of Block*
 *
 * @author		Romuald Conty
 * @date			2006-06-12
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef OPENTURNS_GUIBLOCK_HXX
#define OPENTURNS_GUIBLOCK_HXX

// OT::UI::GUI
#include "QOTObject.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			/**
			 * @class		Block
			 * @brief		Pure virtual class for BlockA, BlockB and BlockC
			 *
			 * This class is used to derive into BlockA, BlockB and BlockC.
			 */

			class Block : public QOTObject
			{
					Q_OBJECT

				public:
					/** Default constructor */
					Block ( QOTObject * parent, const char* name );

					/** Destructor */
					virtual ~Block();

					void getQOTObjects ( QObjectList* objectList );

					virtual QString getFullName() const;

					void setType ( const QString& type );
					QString getType() const;

				public slots:
					void destroy();
					/*
					  virtual QOTObject* duplicateQOTObject( QOTObject* object ) = 0;
					  virtual QOTObject* createQOTObject( const QString& className ) = 0;
					*/
				protected:
					/** Block type : ie "Block A"*/
					QString type_;
			}
			; /* class Block */
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */


#endif /* OPENTURNS_GUIBLOCK_HXX */
