//                                               -*- C++ -*-
/**
 * @file		BlockA.cxx
 * @brief		BlockA are used to input entry variables for StepA
 *
 * @author	Romuald Conty
 * @date		2006-06-13
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

// Header
#include "BlockA.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			/** Default constructor */
			BlockA::BlockA ( QOTObject * parent, const char* name ) : Block ( parent, name )
			{
				A1_ = new Chapter ( this, tr ( "A.1" ), "OpenTURNS::UI::GUI::Chapter" );
				A1_->setTitle ( tr ( "Model" ) );
				A11_ = new Chapter ( A1_, tr ( "A.1.1" ), "OpenTURNS::UI::GUI::EntryVariable" );
				A11_->setTitle ( tr ( "Entry variables" ) );
				QStringList a12ChildrenClasses;
				a12ChildrenClasses << "OpenTURNS::UI::GUI::AnalyticalFunction";
				a12ChildrenClasses << "OpenTURNS::UI::GUI::ExternalCode";
				a12ChildrenClasses << "OpenTURNS::UI::GUI::ResponseSurfaceFunction";
				A12_ = new Chapter ( A1_, tr ( "A.1.2" ), a12ChildrenClasses );
				// 				A12_ = new Chapter( A1_, tr( "A.1.2" ), "OpenTURNS::UI::GUI::ExternalCode" );
				A12_->setTitle ( tr ( "Functions" ) );
				A13_ = new Chapter ( A1_, tr ( "A.1.3" ), "OpenTURNS::UI::GUI::FinalVariable" );
				A13_->setTitle ( tr ( "Final variables" ) );
				A2_ = new Chapter ( this, tr ( "A.2" ), "OpenTURNS::UI::GUI::Chapter" );
				A2_->setTitle ( tr ( "Criterion" ) );
				A21_ = new Chapter ( A2_, tr ( "A.2.1" ), "OpenTURNS::UI::GUI::DeterministicCriterion" );
				A21_->setTitle ( tr ( "Deterministic criterion" ) );
				A22_ = new Chapter ( A2_, tr ( "A.2.2" ), "OpenTURNS::UI::GUI::Chapter" );
				A22_->setTitle ( tr ( "Probabilistic criterion" ) );

				A221_ = new Chapter ( A22_, tr ( "A.2.2.1" ), "OpenTURNS::UI::GUI::CentralDispersion" );
				A221_->setTitle ( tr ( "Central Dispersion" ) );
				A222_ = new Chapter ( A22_, tr ( "A.2.2.2" ), "OpenTURNS::UI::GUI::ThresholdExceedance" );
				A222_->setTitle ( tr ( "Threshold Exceedance" ) );

				setType ( tr ( "Block A" ) );
			}

			/** Destructor */
			BlockA::~BlockA()
			{}

			/** BlockA displayed name accessor */
			QString BlockA::getFullName() const
			{
				return getName();
			}

			/**
			BlockA chapter finder
			@fn Chapter* BlockA::getChapter ( const QString& childrenClassName )
			*/
			Chapter* BlockA::getChapter ( const QString& childrenClassName )
			{
				QObjectList * childrenList = new QObjectList();
				getChildren ( childrenList, "OpenTURNS::UI::GUI::Chapter", true, true );

				for ( uint i = 0; i < childrenList->count(); i++ )
				{
					Chapter * otChild = ( Chapter* ) childrenList->at ( i );
					if ( otChild->canCreateChild ( childrenClassName ) )
						return otChild;
				}
				return NULL;
			}

			EntryVariable* BlockA::getEntryVariable_ptr ( const QString& entryVariableName )
			{
				QObjectList * childrenList = new QObjectList();
				A11_->getChildren ( childrenList, "OpenTURNS::UI::GUI::EntryVariable", true, false );

				for ( uint i = 0; i < childrenList->count(); i++ )
				{
					EntryVariable * otChild = ( EntryVariable* ) childrenList->at ( i );
					if ( otChild->getName() == entryVariableName )
						return otChild;
				}
				return NULL;
			}
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */
