//                                               -*- C++ -*-
/**
 * @file    BlockB.hxx
 * @brief   BlockB is used to link BlockA's variables to distribution
 *
 * @author  Romuald Conty
 * @date    2006-08-28 15:04:21
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#ifndef OPENTURNS_GUIBLOCKB_HXX
#define OPENTURNS_GUIBLOCKB_HXX

// OT::UI::GUI
#include "Block.hxx"
#include "BlockA.hxx"
#include "EntryVariableType.hxx"

// Qt
#include <qtable.h>
#include <qaction.h>
#include <qptrlist.h>

// Visual Components
//#include "QPropertiesTable.hxx"
//#include "QVisualizationTable.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			/**
			 * @class   BlockB
			 * @brief   BlockB is used to link BlockA's variables to distribution
			 *
			 * This class is the graphical representation of a Block which is part of Study's Step.
			 * It used store datas of a BlockB.
			 */
			class BlockB : public Block
			{
					Q_OBJECT
					Q_PROPERTY ( QString block_A READ getBlockA WRITE setBlockA )
				public:
					/** Default constructor */
					BlockB ( QOTObject* parent, const char* name = 0 );

					/** Destructor */
					virtual ~BlockB();

					/** BlockB blockA name accessor */
					bool setBlockA ( const QString& blockAName );

					/** BlockB blockA name accessor */
					QString getBlockA() const;

					/** BlockB blockA pointer accessor */
					void setBlockA_ptr ( BlockA* blockA );

					/** BlockB blockA pointer accessor */
					BlockA * getBlockA_ptr();

					/** BlockB list of entry variable accessor */
					QValueList<EntryVariableType> getEntryVariableTypes();

					/** BlockB list of entry variable accessor */
					void setEntryVariableTypes ( QValueList<EntryVariableType> entryVariableType );

					/** BlockB entry variable finder (from entry variable pointer) */
					EntryVariableType* findEntryVariableType_ptr ( const QString& entryVariableName );

					/** BlockB entry variable finder (from entry variable name) */
					EntryVariableType* findEntryVariableType_ptr ( EntryVariable* entryVariable );

					/** BlockB entry variable finder (from entry variable type name) */
					EntryVariableType* getEntryVariableType_ptr ( const QString& entryVariableTypeName );

				public slots:
					/**  */
					void createEntryVariableType ( QOTObject * OtObject );

				protected:
					/**  */
					BlockA * blockA_;

					/**  */
					QPtrList<EntryVariableType> entryVariableTypes_;
			};

		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

#endif
