//                                               -*- C++ -*-
/**
 * @file		BlockC2.cxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2006-09-25 11:52:00
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#include "BlockC2.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			/** Default constructor */
			BlockC2::BlockC2 ( QOTObject* parent, const char* name ) : Block ( parent, name )
			{
				blockB_ = NULL;
				centralDispertion_ = NULL;
				finalVariable_ = NULL;
				setName ( "BlockC2" );
				setRenameEnabled ( false );
			}

			/** Destructor */
			BlockC2::~BlockC2()
			{}

			/** BlockC2 blockB pointer accessor */
			void BlockC2::setBlockB_ptr ( BlockB* blockB )
			{
				if ( blockB_ != blockB )
				{
					if ( blockB_ != NULL )
					{
						blockB_->disconnect ( this );
					}
					blockB_ = blockB;
					Q_CHECK_PTR ( blockB_ );
					connect ( blockB_, SIGNAL ( renamed() ), this, SIGNAL ( renamed() ) );
					centralDispertion_ = NULL;
					emit updated();
				}
			}

			/** BlockC2 blockB pointer accessor */
			BlockB* BlockC2::getBlockB_ptr()
			{
				return blockB_;
			}

			/** BlockC2 blockB name accessor */
			bool BlockC2::setBlockB ( const QString & blockBName )
			{
				QObject * otParent = this->findParent ( "OpenTURNS::UI::GUI::Study" );
				Q_CHECK_PTR ( otParent );
				if ( otParent != NULL )
				{
					QObjectList * childrenList = new QObjectList();
					( ( QOTObject* ) otParent ) ->getChildren ( childrenList, "OpenTURNS::UI::GUI::BlockB", true, false );
					for ( uint i = 0; i < childrenList->count(); i++ )
					{
						if ( ( ( QOTObject* ) childrenList->at ( i ) ) ->getName() == blockBName )
						{
							setBlockB_ptr ( ( BlockB* ) childrenList->at ( i ) );
							return true;
						}
					}
				}
				return false;
			}

			/** BlockC2 blockB name accessor */
			QString BlockC2::getBlockB() const
			{
				QString blockBName = "";
				if ( blockB_ != NULL )
				{
					blockBName = blockB_->getName();
				}
				return blockBName;
			}

			/** BlockC2 final variable pointer accessor */
			void BlockC2::setFinalVariable_ptr ( FinalVariable* finalVariable )
			{
				Q_CHECK_PTR ( finalVariable );
				if ( finalVariable_ != finalVariable )
				{
					if ( finalVariable_ != NULL )
					{
						finalVariable_->disconnect ( this );
					}
					finalVariable_ = finalVariable;
					emit updated();
				}
			}

			/** BlockC2 final variable pointer accessor */
			FinalVariable* BlockC2::getFinalVariable_ptr()
			{
				return finalVariable_;
			}

			/** BlockC2 final variable name accessor */
			bool BlockC2::setFinalVariable ( const QString& finalVariable )
			{
				QObject * otParent = this->parent();
				while ( otParent != NULL && !otParent->isA ( "OpenTURNS::UI::GUI::Study" ) )
				{
					otParent = otParent->parent();
				}
				Q_CHECK_PTR ( otParent );
				if ( otParent != NULL )
				{
					QObjectList * childrenList = new QObjectList();
					( ( QOTObject* ) otParent ) ->getChildren ( childrenList, "OpenTURNS::UI::GUI::FinalVariable", true, false );
					for ( uint i = 0; i < childrenList->count(); i++ )
					{
						if ( ( ( QOTObject* ) childrenList->at ( i ) ) ->getName() == finalVariable )
						{
							setFinalVariable_ptr ( ( FinalVariable* ) childrenList->at ( i ) );
							return true;
						}
					}
				}
				return false;
			}

			/** BlockC2 final variable name accessor */
			QString BlockC2::getFinalVariable() const
			{
				QString finalVariableName = "";
				if ( finalVariable_ != NULL )
				{
					finalVariableName = finalVariable_->getName();
				}
				return finalVariableName;
			}

			/** BlockC2 threshold exceedance's pointer accessor */
			void BlockC2::setCentralDispersion_ptr ( CentralDispersion * centralDispertion )
			{
				Q_CHECK_PTR ( centralDispertion );
				if ( centralDispertion_ != centralDispertion )
				{
					if ( centralDispertion_ != NULL )
					{
						centralDispertion_->disconnect ( this );
					}
					centralDispertion_ = centralDispertion;
					Q_CHECK_PTR ( centralDispertion_ );
					connect ( centralDispertion_, SIGNAL ( renamed() ), this, SIGNAL ( renamed() ) );

					//if ( calculationC3_ != NULL )
					//	delete calculationC3_;
					//calculationC3_ = new CalculationC3( this, "CalculationC3" );

					emit updated();
				}
			}

			/** BlockC2 threshold exceedance's pointer accessor */
			CentralDispersion * BlockC2::getCentralDispersion_ptr()
			{
				return centralDispertion_;
			}

			/** BlockC2 threshold exceedance's name accessor */
			bool BlockC2::setCentralDispersion ( const QString & centralDispertionName )
			{
				Q_CHECK_PTR ( blockB_ );
				if ( blockB_ != NULL )
				{
					Q_CHECK_PTR ( blockB_->getBlockA_ptr() );
					if ( blockB_->getBlockA_ptr() != NULL )
					{
						QObjectList * childrenList = new QObjectList();
						blockB_->getBlockA_ptr() ->getChildren ( childrenList, "OpenTURNS::UI::GUI::CentralDispersion", true, false );
						for ( uint i = 0; i < childrenList->count(); i++ )
						{
							if ( ( ( QOTObject* ) childrenList->at ( i ) ) ->getName() == centralDispertionName )
							{
								setCentralDispersion_ptr ( ( CentralDispersion* ) childrenList->at ( i ) );
								return true;
							}
						}
						Q_CHECK_PTR ( centralDispertion_ );
					}
				}
				return false;
			}

			/** BlockC2 threshold exceedance's name accessor */
			QString BlockC2::getCentralDispersion() const
			{
				QString centralDispertionName = "";
				if ( centralDispertion_ != NULL )
				{
					centralDispertionName = centralDispertion_->getName();
				}
				return centralDispertionName;
			}


			QString BlockC2::getFullName() const
			{
				Q_CHECK_PTR ( blockB_ );
				Q_CHECK_PTR ( centralDispertion_ );
				QString fullName = tr ( "no block B and/or central dispertion" );
				if ( blockB_ != NULL )
				{
					if ( centralDispertion_ != NULL )
					{
						fullName = blockB_->getName() + tr ( " with " ) + centralDispertion_->getName();
					}
				}
				return fullName;
			}
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

