//                                               -*- C++ -*-
/**
 * @file		BlockC3.cxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2006-09-01 11:40:05
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
//header
#include "BlockC3.hxx"

// OT::UI::GUI

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			/** Default constructor */
			BlockC3::BlockC3 ( QOTObject* parent, const char* name ) : Block ( parent, name )
			{
				blockB_ = NULL;
				thresholdExceedance_ = NULL;
				finalVariable_ = NULL;
				setRenameEnabled ( false );
			}

			/** Destructor */
			BlockC3::~BlockC3()
			{}

			/** BlockC3 blockB pointer accessor */
			void BlockC3::setBlockB_ptr ( BlockB* blockB )
			{
				if ( blockB_ != blockB )
				{
					if ( blockB_ != NULL )
					{
						blockB_->disconnect ( this );
					}
					blockB_ = blockB;
					Q_CHECK_PTR ( blockB_ );
					connect ( blockB_, SIGNAL ( renamed() ), this, SIGNAL ( renamed() ) );
					thresholdExceedance_ = NULL;
					emit updated();
				}
			}

			/** BlockC3 blockB pointer accessor */
			BlockB* BlockC3::getBlockB_ptr()
			{
				return blockB_;
			}

			/** BlockC3 blockB name accessor */
			bool BlockC3::setBlockB ( const QString & blockBName )
			{
				QObject * otParent = this->findParent ( "OpenTURNS::UI::GUI::Study" );
				Q_CHECK_PTR ( otParent );
				if ( otParent != NULL )
				{
					QObjectList * childrenList = new QObjectList();
					( ( QOTObject* ) otParent ) ->getChildren ( childrenList, "OpenTURNS::UI::GUI::BlockB", true, false );
					for ( uint i = 0; i < childrenList->count(); i++ )
					{
						if ( ( ( QOTObject* ) childrenList->at ( i ) ) ->getName() == blockBName )
						{
							setBlockB_ptr ( ( BlockB* ) childrenList->at ( i ) );
							return true;
						}
					}
				}
				return false;
			}

			/** BlockC3 blockB name accessor */
			QString BlockC3::getBlockB() const
			{
				QString blockBName = "";
				if ( blockB_ != NULL )
				{
					blockBName = blockB_->getName();
				}
				return blockBName;
			}

			/** BlockC3 final variable pointer accessor */
			void BlockC3::setFinalVariable_ptr ( FinalVariable* finalVariable )
			{
				Q_CHECK_PTR ( finalVariable );
				if ( finalVariable_ != finalVariable )
				{
					if ( finalVariable_ != NULL )
					{
						finalVariable_->disconnect ( this );
					}
					finalVariable_ = finalVariable;
					emit updated();
				}
			}

			/** BlockC3 final variable pointer accessor */
			FinalVariable* BlockC3::getFinalVariable_ptr()
			{
				return finalVariable_;
			}

			/** BlockC3 final variable name accessor */
			bool BlockC3::setFinalVariable ( const QString& finalVariable )
			{
				QObject * otParent = this->parent();
				while ( otParent != NULL && !otParent->isA ( "OpenTURNS::UI::GUI::Study" ) )
				{
					otParent = otParent->parent();
				}
				Q_CHECK_PTR ( otParent );
				if ( otParent != NULL )
				{
					QObjectList * childrenList = new QObjectList();
					( ( QOTObject* ) otParent ) ->getChildren ( childrenList, "OpenTURNS::UI::GUI::FinalVariable", true, false );
					for ( uint i = 0; i < childrenList->count(); i++ )
					{
						if ( ( ( QOTObject* ) childrenList->at ( i ) ) ->getName() == finalVariable )
						{
							setFinalVariable_ptr ( ( FinalVariable* ) childrenList->at ( i ) );
							return true;
						}
					}
				}
				return false;
			}

			/** BlockC3 final variable name accessor */
			QString BlockC3::getFinalVariable() const
			{
				QString finalVariableName = "";
				if ( finalVariable_ != NULL )
				{
					finalVariableName = finalVariable_->getName();
				}
				return finalVariableName;
			}

			/** BlockC3 threshold exceedance's pointer accessor */
			void BlockC3::setThresholdExceedance_ptr ( ThresholdExceedance * thresholdExceedance )
			{
				Q_CHECK_PTR ( thresholdExceedance );
				if ( thresholdExceedance_ != thresholdExceedance )
				{
					if ( thresholdExceedance_ != NULL )
					{
						thresholdExceedance_->disconnect ( this );
					}
					thresholdExceedance_ = thresholdExceedance;
					Q_CHECK_PTR ( thresholdExceedance_ );
					connect ( thresholdExceedance_, SIGNAL ( renamed() ), this, SIGNAL ( renamed() ) );

					//if ( calculationC3_ != NULL )
					//	delete calculationC3_;
					//calculationC3_ = new CalculationC3( this, "CalculationC3" );

					emit updated();
				}
			}

			/** BlockC3 threshold exceedance's pointer accessor */
			ThresholdExceedance * BlockC3::getThresholdExceedance_ptr()
			{
				return thresholdExceedance_;
			}

			/** BlockC3 threshold exceedance's name accessor */
			bool BlockC3::setThresholdExceedance ( const QString & thresholdExceedanceName )
			{
				if ( blockB_ != NULL && blockB_->getBlockA_ptr() != NULL )
				{
					QObjectList * childrenList = new QObjectList();
					blockB_->getBlockA_ptr() ->getChildren ( childrenList, "OpenTURNS::UI::GUI::ThresholdExceedance", true, false );
					for ( uint i = 0; i < childrenList->count(); i++ )
					{
						if ( ( ( QOTObject* ) childrenList->at ( i ) ) ->getName() == thresholdExceedanceName )
						{
							setThresholdExceedance_ptr ( ( ThresholdExceedance* ) childrenList->at ( i ) );
							return true;
						}
					}
				}
				return false;
			}

			/** BlockC3 threshold exceedance's name accessor */
			QString BlockC3::getThresholdExceedance() const
			{
				QString thresholdExceedanceName = "";
				if ( thresholdExceedance_ != NULL )
				{
					thresholdExceedanceName = thresholdExceedance_->getName();
				}
				return thresholdExceedanceName;
			}


			QString BlockC3::getFullName() const
			{
				Q_CHECK_PTR ( blockB_ );
				Q_CHECK_PTR ( thresholdExceedance_ );
				QString fullName = tr ( "no block B and/or threshold exceedance" );
				if ( blockB_ != NULL )
				{
					if ( thresholdExceedance_ != NULL )
					{
						fullName = blockB_->getName() + tr ( " with " ) + thresholdExceedance_->getName();
					}
				}
				return fullName;
			}
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

