//                                               -*- C++ -*-
/**
 * @file		BlockFunctionProperty.cxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2007-01-09 09:15:10
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "BlockFunctionProperty.hxx"

namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			BlockFunctionProperty::BlockFunctionProperty ( NumericalMathFunction* numericalMathFunction, BlockA* blockA, QObject* parent, const char* name ) : NumericalMathFunctionProperty ( numericalMathFunction, parent, name )
			{
				Q_CHECK_PTR ( blockA );
				blockA_ = blockA;
				connect ( blockA_, SIGNAL ( updated() ), this, SLOT ( blockUpdated() ) );

				function_ = NULL;
			}

			BlockFunctionProperty::~BlockFunctionProperty()
			{}

			QString BlockFunctionProperty::getValue()
			{
				Q_CHECK_PTR ( function_ );
				if ( function_ )
				{
					return function_->getName();
				}
				else
				{
					return QString ( "" );
				}
			}

			bool BlockFunctionProperty::setValue ( QString value )
			{
				Q_CHECK_PTR ( blockA_ );
				if ( blockA_ != NULL )
				{
					QObjectList * childrenList = new QObjectList();
					blockA_->getChildren ( childrenList, "OpenTURNS::UI::GUI::Function", true, true );

					for ( uint i = 0; i < childrenList->count(); i++ )
					{
						QOTObject * otChild = ( QOTObject* ) childrenList->at ( i );
						if ( otChild->getName() == value )
						{
							setFunction ( ( Function* ) otChild );
							return true;
							break;
						}
					}
				}
				return false;
			}

			void BlockFunctionProperty::setFunction ( Function* function )
			{
				qDebug ( "BlockFunctionProperty::setFunction( Function* function )" );
				Q_CHECK_PTR ( function );
				Q_CHECK_PTR ( function_ );
				if ( function != function_ )
				{
					if ( function_ != NULL )
					{
						function_->disconnect ( this );
					}
					function_ = function;

					connect ( function_, SIGNAL ( updated() ), this , SLOT ( functionUpdated() ) );
					functionUpdated();
				}
			}

			QStringList BlockFunctionProperty::getChoices()
			{
				QStringList choices;
				QObjectList * childrenList = new QObjectList();
				blockA_->getChildren ( childrenList, "OpenTURNS::UI::GUI::Function", true, true );
				if ( childrenList->count() )
				{
					for ( uint i = 0; i < childrenList->count(); i++ )
					{
						QOTObject * otChild = ( QOTObject* ) childrenList->at ( i );
						if ( otChild->getName() != parent() ->name() )
						{
							choices.append ( otChild->getName() );
						}
					}
				}

				return choices;
			}

			void BlockFunctionProperty::functionUpdated()
			{
				qDebug ( "BlockFunctionProperty::functionUpdated()" );
				Q_CHECK_PTR ( numericalMathFunction_ );

				( *numericalMathFunction_ ) = function_->getNumericalMathFunction();

				displaySubproperties();

				emit updated();
			}

			void BlockFunctionProperty::blockUpdated()
			{
				qDebug ( "BlockFunctionProperty::blockUpdated()" );
				emit updated();
			}

			void BlockFunctionProperty::displaySubproperties()
			{
				qDebug ( "BlockFunctionProperty::displaySubproperties()" );
				displayInputs();
				displayOutputs();
			}

		}

	}

}
