//                                               -*- C++ -*-
/**
 * @file		BlockFunctionProperty.hxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2007-01-09 09:15:10
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#ifndef OPENTURNS_UI_GUIBLOCKFUNCTIONPROPERTY_HXX
#define OPENTURNS_UI_GUIBLOCKFUNCTIONPROPERTY_HXX

// OT::GUI::UI
#include "NumericalMathFunctionProperty.hxx"
#include "Function.hxx"
#include "BlockA.hxx"

namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			class BlockFunctionProperty : public NumericalMathFunctionProperty
			{
					Q_OBJECT
				public:
					BlockFunctionProperty ( NumericalMathFunction* numericalMathFunction, BlockA* blockA, QObject* parent, const char* name );

					~BlockFunctionProperty();

					virtual QString getValue();
					virtual bool setValue ( QString value );

					void setFunction ( Function* function );

					QStringList getChoices();

				protected:
					virtual void displaySubproperties();

				protected slots:
					virtual void blockUpdated();
					virtual void functionUpdated();

				protected:
					Function* function_;
					BlockA* blockA_;
			};

		}

	}

}

#endif
