//                                               -*- C++ -*-
/**
 * @file    Calculation.hxx
 * @brief
 *
 * @author  Romuald Conty
 * @date    2006-09-07 12:26:01
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#ifndef OPENTURNS_GUICALCULATION_HXX
#define OPENTURNS_GUICALCULATION_HXX

// OT::UI::GUI
#include "Chapter.hxx"
#include "FinalVariable.hxx"
#include "BlockB.hxx"

// Qt
#include <qthread.h>
#include <qevent.h>

// OT
#include "OT.hxx"
#include "RandomVector.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{

			typedef OT::Uncertainty::Model::RandomVector RandomVector;

			class Calculation : public Chapter, public QThread
			{
					Q_OBJECT
				public:
					/** Default constructor */
					Calculation ( QOTObject *parent, const char *name );

					/** Destructor */
					virtual ~Calculation();

					/** Calculation error code accessor */
					int getErrorCode();

				public slots:
					void process();

				signals:
					void preprocessing();
					void postprocessing();

				protected:
					virtual int processing() = 0;

					RandomVector createOutputRandomVector ( FinalVariable* finalVariable, BlockB* blockB );

					virtual void customEvent ( QCustomEvent * );

				private:
					void run();

					/** Lastest computing error code */
					int errorCode_;

					/** Error code mutex */
					QMutex errorCodeMutex_;

					QOTAction * actionRun_;
					QCustomEvent * eventUpdate;
			};
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

#endif
