//                                               -*- C++ -*-
/**
 * @file			Chapter.cxx
 * @brief
 *
 * @author		Romuald Conty
 * @date			2006-07-12 15:26:51
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "Chapter.hxx"

// OT::UI::GUI
// A.1
// A.1.1
#include "EntryVariable.hxx"
// A.1.2
// A.1.2.1
#include "AnalyticalFunction.hxx"
// A.1.2.2
#include "ExternalCode.hxx"
// A.1.2.3
#include "ResponseSurfaceFunction.hxx"
// A.1.3
#include "FinalVariable.hxx"
// A.2
// A.2.1
#include "DeterministicCriterion.hxx"
// A.2.2
// A.2.2.1
#include "CentralDispersion.hxx"
// A.2.2.2
#include "ThresholdExceedance.hxx"
// A.2.2.3
//#include "FractileCriterion.hxx"

#include "QOTAction.hxx"

// Qt
#include <qinputdialog.h>

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			/** Default constructor */
			Chapter::Chapter ( QOTObject *parent, const char *name, const QStringList childrenClassesName ) : QOTObject ( parent, name )
			{
				childrenClassesName_ = childrenClassesName;

				//QOTAction * actionView = new QOTAction( tr( "View this object" ), 0, this, "Chapter_view" );

				if ( childrenClassesName_[ 0 ] != getClassName() && childrenClassesName_[ 0 ] != "" )
				{
					QOTAction * actionNew = new QOTAction ( tr ( "Create an object" ), 0, this, "Chapter_newObject" );

					connect ( actionNew, SIGNAL ( activated() ) , this, SLOT ( createChild() ) );
				}
			}

			/** Destructor */
			Chapter::~Chapter()
			{}

			/** Chapter title accessor */
			void Chapter::setTitle ( const QString& title )
			{
				title_ = title;
			}

			/** Chapter title accessor */
			QString Chapter::getTitle() const
			{
				return title_;
			}

			/** Chapter fullname (name + title) accessor */
			QString Chapter::getFullName() const
			{
				return getName() + " : " + getTitle();
			}

			/** Chapter children classes name */
			const QStringList* Chapter::getChildrenClassesName() const
			{
				return & childrenClassesName_;
			}

			/** Function used to find the parent Block of a Content */
			Block* Chapter::getParentBlock()
			{
				QObject * obj = parent();
				while ( obj != NULL && obj->isA ( "OpenTURNS::UI::GUI::Chapter" ) )
				{
					obj = obj->parent();
				}
				if ( obj != NULL && obj->inherits ( "OpenTURNS::UI::GUI::Block" ) )
				{
					return ( Block* ) obj;
				}
				else
				{
					return NULL;
				}
			}

			/** Qt slot, invoked by user, used to create a child to this chapter */
			void Chapter::createChild()
			{
				if ( childrenClassesName_.count() == 1 )
				{
					// only one child type (ie: EntryVariable)
					if ( childrenClassesName_[ 0 ] == "OpenTURNS::UI::GUI::EntryVariable" )
					{
						QOTObject * otObject = new EntryVariable ( this, "EntryVariable" );
						emit childCreated ( otObject );
					}
					else if ( childrenClassesName_[ 0 ] == "OpenTURNS::UI::GUI::FinalVariable" )
					{
						QOTObject * otObject = new FinalVariable ( this, "FinalVariable" );
						emit childCreated ( otObject );
					}
					else if ( childrenClassesName_[ 0 ] == "OpenTURNS::UI::GUI::DeterministicCriterion" )
					{
						QOTObject * otObject = new DeterministicCriterion ( this, "DeterministicCriterion" );
						emit childCreated ( otObject );
					}
					else if ( childrenClassesName_[ 0 ] == "OpenTURNS::UI::GUI::ThresholdExceedance" )
					{
						QOTObject * otObject = new ThresholdExceedance ( this, "ThresholdExceedance" );
						emit childCreated ( otObject );
					}
					else if ( childrenClassesName_[ 0 ] == "OpenTURNS::UI::GUI::CentralDispersion" )
					{
						QOTObject * otObject = new CentralDispersion ( this, "CentralDispersion" );
						emit childCreated ( otObject );
					}
					else if ( childrenClassesName_[ 0 ] == "OpenTURNS::UI::GUI::ExternalCode" )
					{
						QOTObject * otObject = new ExternalCode ( this, "ExternalCode" );
						emit childCreated ( otObject );
					}
					else
					{
						qWarning ( QString ( QString ( "Unable to create this type : \"" ) + childrenClassesName_[ 0 ] + QString ( "\"" ) ).ascii() );
					}
				}
				else if ( childrenClassesName_.count() == 0 )
				{
					// Something is strange...
					qWarning ( "A chapter have been created without content's creation capabilities" );
				}
				else
				{
					bool ok;
					QString choose = QInputDialog::getItem ( tr ( "Create child..." ), tr ( "Choose class" ), childrenClassesName_, 0, FALSE, &ok );
					if ( ok )
					{
						if ( choose == "OpenTURNS::UI::GUI::AnalyticalFunction" )
						{
							QOTObject * otObject = new AnalyticalFunction ( this, "AnalyticalFunction" );
							emit childCreated ( otObject );
						}
						else if ( choose == "OpenTURNS::UI::GUI::ExternalCode" )
						{
							QOTObject * otObject = new ExternalCode ( this, "ExternalCode" );
							emit childCreated ( otObject );
						}
						else if ( choose == "OpenTURNS::UI::GUI::ResponseSurfaceFunction" )
						{
							QOTObject * otObject = new ResponseSurfaceFunction ( this, "ResponseSurfaceFunction" );
							emit childCreated ( otObject );
						}
					}
				}
			}

			/** Qt slot, invoked by user, used to duplicate 'brother' */
			void Chapter::createChild ( QOTObject * brother )
			{
				if ( brother->getClassName() == "OpenTURNS::UI::GUI::EntryVariable" )
				{
					QOTObject * otObject = new EntryVariable ( * ( ( EntryVariable* ) brother ), this );
					emit childCreated ( otObject );
				}
				else if ( brother->getClassName() == "OpenTURNS::UI::GUI::AnalyticalFunction" )
				{
					QOTObject * otObject = new AnalyticalFunction ( * ( ( AnalyticalFunction* ) brother ), this );
					emit childCreated ( otObject );
				}
				else if ( brother->getClassName() == "OpenTURNS::UI::GUI::ExternalCode" )
				{
					QOTObject * otObject = new ExternalCode ( * ( ( ExternalCode* ) brother ), this );
					emit childCreated ( otObject );
				}
				else if ( brother->getClassName() == "OpenTURNS::UI::GUI::FinalVariable" )
				{
					QOTObject * otObject = new FinalVariable ( * ( ( FinalVariable* ) brother ), this );
					emit childCreated ( otObject );
				}
			}

			bool Chapter::canCreateChild ( const QString& childrenClassName )
			{
				for ( uint i = 0; i < childrenClassesName_.count(); i++ )
				{
					if ( childrenClassesName_[ i ] == childrenClassName )
						return true;
				}
				return false;
			}
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

