//                                               -*- C++ -*-
/**
 * @file			Content.cxx
 * @brief
 *
 * @author		Romuald Conty
 * @date			2006-07-19 17:18:22
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "Content.hxx"

// OT::UI::GUI
#include "Chapter.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			Content::Content ( QOTObject *parent, const char *name ) : QOTObject ( parent, name )
			{
				actionRemove_ = new QOTAction ( tr ( "Delete this object" ), 0, this, "Content_deleteObject" );
				connect ( actionRemove_, SIGNAL ( activated() ), this, SLOT ( destroy() ) );

				actionCopy_ = new QOTAction ( tr ( "Copy this object" ), 0, this, "Content_copyObject" );
				connect ( actionCopy_, SIGNAL ( activated() ), this, SLOT ( duplicate() ) );

				renameEnabled_ = true;
				setName ( parent->giveUniqueChildName ( name ) );
			}

			void Content::destroy()
			{
				emit destroyed ( this );
				delete this;
			}

			void Content::assignToMe ( const Content & other )
			{
				QString myName = ( ( QOTObject* ) parent() ) ->giveUniqueChildName ( other.name() );
				QOTObject::assignToMe ( other );
				setName ( myName );
			}

			void Content::duplicate()
			{
				QObject * chapter = parent();
				if ( chapter != NULL && chapter->isA ( "OpenTURNS::UI::GUI::Chapter" ) )
				{
					( ( Chapter* ) chapter ) ->createChild ( this );
				}
			}

			Block* Content::getParentBlock()
			{
				QObject * obj = parent();
				while ( obj != NULL && obj->isA ( "OpenTURNS::UI::GUI::Chapter" ) )
				{
					obj = obj->parent();
				}
				if ( obj != NULL && obj->inherits ( "OpenTURNS::UI::GUI::Block" ) )
				{
					return ( Block* ) obj;
				}
				else
				{
					return NULL;
				}
			}

			Content::~Content()
			{}

		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

