//                                               -*- C++ -*-
/**
 * @file		Criterion.hxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2006-08-28 10:11:10
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#ifndef OPENTURNS_GUICRITERION_HXX
#define OPENTURNS_GUICRITERION_HXX

// OT::UI::GUI
#include "Content.hxx"

// Qt
#include <qvaluelist.h>
#include <qvariant.h>

// OT
#include "Description.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			class Criterion : public Content
			{
					Q_OBJECT
				public:
					/** Default constructor */
					Criterion ( QOTObject *parent, const char *name = 0 );

					/** Copy constructor */
					Criterion ( const Criterion & other, QOTObject* parent );

					/** Destructor */
					virtual ~Criterion();

					/** The function that actually realizes assignment between objects */
					void assignToMe ( const Criterion & other );

				protected:
					Description finalVariable_;

			};

		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */


#endif
