//                                               -*- C++ -*-
/**
 * @file		DeterministicCriterion.cxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2006-08-25 14:05:49
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "DeterministicCriterion.hxx"

// OT::UI::GUI
#include "NumericalPointProperty.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			/** Default constructor */
			DeterministicCriterion::DeterministicCriterion ( QOTObject *parent, const char *name )
					: Criterion ( parent, name )
			{
				new NumericalPointProperty ( &lowerBound_, true, this, "lower bound" );
				new NumericalPointProperty ( &upperBound_, true, this, "upper bound" );
				new NumericalPointProperty ( &discretisation_, true, this, "discretisation" );

			}

			/** Copy constructor */
			DeterministicCriterion::DeterministicCriterion ( const DeterministicCriterion & other, QOTObject* parent ) : Criterion ( parent )
			{
				assignToMe ( other );
			}

			/** Destructor */
			DeterministicCriterion::~DeterministicCriterion()
			{}

			/** The function that actually realizes assignment between objects */
			void DeterministicCriterion::assignToMe ( const DeterministicCriterion & other )
			{
				Criterion::assignToMe ( other );
			}

			NumericalPoint DeterministicCriterion::getLowerBound() const
			{
				return lowerBound_;
			}

			NumericalPoint DeterministicCriterion::getUpperBound() const
			{
				return upperBound_;
			}

			NumericalPoint DeterministicCriterion::getDiscretisation() const
			{
				return discretisation_;
			}

		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

