//                                               -*- C++ -*-
/**
 * @file		DistributionProperty.hxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2007-01-12 11:40:42
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#ifndef OPENTURNS_UI_GUIDISTRIBUTIONPROPERTY_HXX
#define OPENTURNS_UI_GUIDISTRIBUTIONPROPERTY_HXX

// OT::UI::GUI
#include "QOTProperty.hxx"

// OT
#include "Distribution.hxx"
#include "NumericalPoint.hxx"

namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			typedef OT::Uncertainty::Model::Distribution Distribution;
			typedef OT::Base::Type::NumericalPoint NumericalPoint;

			class DistributionProperty : public QOTProperty
			{
					Q_OBJECT
				public:
					DistributionProperty ( Distribution* distribution, QObject* parent, const char* name );

					~DistributionProperty();

					virtual QString getValue();
					virtual QStringList getChoices();
					virtual bool setValue ( QString value );

				public slots:
					void drawPDF();
					void drawCDF();
					void generateDistribution();

					void propertyUpdated ( QOTProperty* subproperty );


				protected:
					void autoconnect ( QOTProperty* property );

				protected:
					QString distributionTitle_;
					Distribution* distribution_;

					NumericalPoint arguments_;

			};

		}

	}

}

#endif
