//                                               -*- C++ -*-
/**
 * @file		EntryVariable.hxx
 * @brief		Store information about an entry variable
 *
 * @author		Romuald Conty
 * @date			2006-06-22
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef OPENTURNS_GUIENTRYVARIABLE_HXX
#define OPENTURNS_GUIENTRYVARIABLE_HXX

// OT::UI::GUI
#include "Content.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			/**
			 * @class		EntryVariable
			 * @brief		Entry variable needed in StepA
			 *
			 * This class represents an entry variable.
			 * It used to store data about this variable.
			 */

			class EntryVariable : public Content
			{
					Q_OBJECT

					Q_PROPERTY ( double typical_value READ getValue WRITE setValue )

				public:

					/** Default constructor */
					EntryVariable ( QOTObject* parent, const char * name = 0 );

					/** Copy constructor */
					EntryVariable ( const EntryVariable & other, QOTObject* parent );

					/** Destructor */
					~EntryVariable();

					/** Comparison operator */
					bool operator == ( const EntryVariable & other ) const;

					/** EntryVariable value accessor */
					void setValue ( const double & value );

					/** EntryVariable value accessor */
					bool setValue ( const QString & value );

					/** EntryVariable value accessor */
					double getValue() const;

				protected:
					/** The function that actually realizes assignment between entry variables */
					void assignToMe ( const EntryVariable & other );

					NumericalScalar typicalValue_;
			};
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

#endif
