//                                               -*- C++ -*-
/**
 * @file		EntryVariableProperty.cxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2007-01-10 11:38:11
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "EntryVariableProperty.hxx"

namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			EntryVariableProperty::EntryVariableProperty ( Description* description, const uint index, BlockA* blockA, QObject *parent, const char *name )
					: DescriptionProperty ( description, index, true, parent, name )
			{
				Q_CHECK_PTR ( blockA );
				blockA_ = blockA;
				connect ( blockA_, SIGNAL ( updated() ), this, SLOT ( blockUpdated() ) );

				setType ( QOTProperty::MultipleChoice );
			}


			EntryVariableProperty::~EntryVariableProperty()
			{}

			QStringList EntryVariableProperty::getChoices()
			{
				QStringList choices;
				QObjectList * childrenList = new QObjectList();
				blockA_->getChildren ( childrenList, "OpenTURNS::UI::GUI::EntryVariable", true, true );
				if ( childrenList->count() )
				{
					for ( uint i = 0; i < childrenList->count(); i++ )
					{
						QOTObject * otChild = ( QOTObject* ) childrenList->at ( i );
						if ( otChild->getName() != parent() ->name() )
						{
							choices.append ( otChild->getName() );
						}
					}
				}

				return choices;
			}

			void EntryVariableProperty::blockUpdated()
			{
				qDebug ( "EntryVariableProperty::blockUpdated()" );
				emit updated();
			}

		}

	}

}
