//                                               -*- C++ -*-
/**
 * @file		ExperimentProperty.cxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2007-01-05 11:28:13
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "ExperimentProperty.hxx"

// OT::UI::GUI
#include "NumericalPointProperty.hxx"

namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			ExperimentProperty::ExperimentProperty ( Experiment* experiment, QObject *parent, const char *name )
					: QOTProperty ( QOTProperty::MultipleChoice, parent, name )
			{
				designOfExperiment_ = "";

				experiment_ = experiment;
				center_ = NumericalPoint ( 1 ); // must be input dimension of the parent numerical math function.
				levels_ = NumericalPoint ( 1, 1.0 );
			}

			ExperimentProperty::~ExperimentProperty()
			{}

			QString ExperimentProperty::getValue()
			{
				return designOfExperiment_;
			}

			bool ExperimentProperty::setValue ( QString value )
			{
				qDebug ( "ExperimentProperty::setValue( QString value )" );
				if ( designOfExperiment_ != value )
				{

					QOTProperties subproperties = getSubproperties ( false );
					subproperties.setAutoDelete ( true );
					subproperties.clear();

					if ( value == "axial" )
					{
						designOfExperiment_ = "axial";
						( *experiment_ ) = Axial ( center_, levels_ );
					}
					else if ( value == "factorial" )
					{
						designOfExperiment_ = "factorial";
						( *experiment_ ) = Factorial ( center_, levels_ );
					}
					else if ( value == "composite" )
					{
						designOfExperiment_ = "composite";
						( *experiment_ ) = Composite ( center_, levels_ );
					}
					QOTProperty* centerProperty = new NumericalPointProperty ( &center_, true, this, "center" );
					QOTProperty* levelsProperty = new NumericalPointProperty ( &levels_, true, this, "levels" );

					connect ( centerProperty, SIGNAL ( updated() ), this, SLOT ( centerUpdated() ) );
					connect ( levelsProperty, SIGNAL ( updated() ), this, SLOT ( levelsUpdated() ) );

					subpropertyUpdated ( centerProperty );
					subpropertyUpdated ( levelsProperty );

					emit updated();
					return true;
				}
				return false;
			}

			QStringList ExperimentProperty::getChoices()
			{
				QStringList choices;
				choices << "axial" << "factorial" << "composite";
				return choices;
			}

			void ExperimentProperty::centerUpdated()
			{
				qDebug ( "ExperimentProperty::centerUpdated()" );
				experiment_->setCenter ( center_ );
				emit updated();
			}

			void ExperimentProperty::levelsUpdated()
			{
				qDebug ( "ExperimentProperty::levelsUpdated()" );
				experiment_->setLevels ( levels_ );
				emit updated();
			}

		}

	}

}
