//                                               -*- C++ -*-
/**
 * @file		ExperimentProperty.hxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2007-01-05 11:28:13
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#ifndef OPENTURNS_UI_GUIDESIGNOFEXPERIMENTPROPERTY_HXX
#define OPENTURNS_UI_GUIDESIGNOFEXPERIMENTPROPERTY_HXX

#include "QOTProperty.hxx"

// OT
#include "NumericalSample.hxx"

#include "Axial.hxx"
#include "Factorial.hxx"
#include "Composite.hxx"

#include "Experiment.hxx"

namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			typedef OT::Base::Stat::NumericalSample NumericalSample;
			typedef OT::Base::Type::NumericalPoint NumericalPoint;

			typedef OT::Uncertainty::Algorithm::Axial Axial;
			typedef OT::Uncertainty::Algorithm::Factorial Factorial;
			typedef OT::Uncertainty::Algorithm::Composite Composite;

			typedef OT::Uncertainty::Algorithm::Experiment Experiment;

			class ExperimentProperty : public QOTProperty
			{
					Q_OBJECT
				public:
					ExperimentProperty ( Experiment* experiment, QObject *parent, const char *name );

					~ExperimentProperty();

					virtual QString getValue();
					virtual bool setValue ( QString value );

					QStringList getChoices();

				protected:
					QString designOfExperiment_;

					Experiment* experiment_;
					NumericalPoint center_;
					NumericalPoint levels_;

				private slots:
					void centerUpdated();
					void levelsUpdated();

			};

		}

	}

}

#endif
