//                                               -*- C++ -*-
/**
 * @file		FinalVariable.hxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2006-08-21 09:57:43
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#ifndef OPENTURNS_GUIFINALVARIABLE_HXX
#define OPENTURNS_GUIFINALVARIABLE_HXX

// OT::UI::GUI
#include "Content.hxx"
#include "Parameter.hxx"
#include "Function.hxx"
#include "GradientCalculationProperty.hxx"
#include "HessianCalculationProperty.hxx"
#include "VariablesAssociationProperty.hxx"

// OT
#include "NumericalMathFunction.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			class FinalVariable : public Content
			{
					Q_OBJECT
				public:

					/** Default constructor */
					FinalVariable ( QOTObject* parent, const char * name = 0 );

					/** Copy constructor */
					FinalVariable ( const FinalVariable & other, QOTObject* parent );

					/** Destructor */
					~FinalVariable();

					GradientCalculationProperty* getGradientCalculationProperty();

					HessianCalculationProperty* getHessianCalculationProperty();

					NumericalMathFunction getNumericalMathFunction() const;

					Description getInputVariables() const;

				protected:
					/** The function that actually realizes assignment between entry variables */
					void assignToMe ( const FinalVariable & other );

				protected:
					VariablesAssociationProperty* variablesAssociationProperty_;

					GradientCalculationProperty* gradientCalculationProperty_;

					HessianCalculationProperty* hessianCalculationProperty_;

					NumericalMathFunction numericalMathFunction_;

			};
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

#endif
