//                                               -*- C++ -*-
/**
 * @file		NumericalMathFunctionProperty.cxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2007-01-14 18:20:37
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "NumericalMathFunctionProperty.hxx"

// OT::UI::GUI
#include "QOTAction.hxx"
#include "DescriptionProperty.hxx"

namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			NumericalMathFunctionProperty::NumericalMathFunctionProperty ( NumericalMathFunction * numericalMathFunction, const bool editable, QObject* parent, const char* name ) : QOTProperty ( ( ( editable ) ? ( QOTProperty::SimpleText ) : ( QOTProperty::NotEditable ) ), parent, name )
			{
				numericalMathFunction_ = numericalMathFunction;
				inputsProperties_.setAutoDelete ( true );
				outputsProperties_.setAutoDelete ( true );
			}

			NumericalMathFunctionProperty::NumericalMathFunctionProperty ( NumericalMathFunction * numericalMathFunction, QObject* parent, const char* name )
					: QOTProperty ( QOTProperty::MultipleChoice, parent, name )
			{
				numericalMathFunction_ = numericalMathFunction;
				inputsProperties_.setAutoDelete ( true );
				outputsProperties_.setAutoDelete ( true );
			}

			NumericalMathFunctionProperty::~NumericalMathFunctionProperty()
			{}

			void NumericalMathFunctionProperty::displayInputs()
			{
				const OT::UnsignedLong inputsDimension = numericalMathFunction_->getInputNumericalPointDimension();
				inputs_ = numericalMathFunction_->getInputDescription();
				inputsProperties_.clear();

				for ( uint i = 0; i < inputsDimension; i++ )
				{
					DescriptionProperty* descriptionProperty = new DescriptionProperty ( &inputs_, i, false, this, QString ( QString ( "input " ) + QString::number ( i + 1 ) ).ascii() );
					inputsProperties_.append ( descriptionProperty );
					subpropertyUpdated ( descriptionProperty );
				}
			}

			void NumericalMathFunctionProperty::displayOutputs()
			{
				const OT::UnsignedLong outputsDimension = numericalMathFunction_->getOutputNumericalPointDimension();
				outputs_ = numericalMathFunction_->getOutputDescription();
				outputsProperties_.clear();

				/** @todo include this "autonaming" function in NumericalMathFunction */
				if ( outputs_.getSize() < outputsDimension )
				{
					outputs_ = Description ( outputsDimension );
					for ( uint i = 0; i < outputs_.getSize(); i++ )
					{
						outputs_[ i ] = QString ( QString ( "output" ) + QString::number ( i + 1 ) ).ascii();
					}
				}

				for ( uint i = 0; i < outputsDimension; i++ )
				{
					DescriptionProperty* descriptionProperty = new DescriptionProperty ( &outputs_, i, false, this, QString ( QString ( "output " ) + QString::number ( i + 1 ) ).ascii() );
					outputsProperties_.append ( descriptionProperty );
					subpropertyUpdated ( descriptionProperty );
				}
			}

		}

	}

}
