//                                               -*- C++ -*-
/**
 * @file		NumericalPointProperty.cxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2007-01-11 11:33:05
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "NumericalPointProperty.hxx"

namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			NumericalPointProperty::NumericalPointProperty ( NumericalPoint* numericalPoint, const bool editable, QObject* parent, const char* name ) : QOTProperty ( ( ( editable ) ? ( QOTProperty::SimpleText ) : ( QOTProperty::NotEditable ) ), parent, name )
			{
				numericalPoint_ = numericalPoint;
			}


			NumericalPointProperty::~NumericalPointProperty()
			{}


			QString NumericalPointProperty::getValue()
			{
				QString value;
				UnsignedLong dimension = numericalPoint_->getDimension();
				for ( UnsignedLong i = 0; i < dimension; i++ )
				{
					value += QString::number ( ( *numericalPoint_ ) [ i ] ) + QString ( ";" );
				}
				return value;
			}

			bool NumericalPointProperty::setValue ( QString value )
			{
				/** @todo check if "value" is really a new value. */
				QStringList numbers = QStringList::split ( ";", value );
				UnsignedLong dimension = numbers.count();
				( *numericalPoint_ ) = NumericalPoint ( dimension );
				bool error = false;
				for ( UnsignedLong i = 0; i < dimension; i++ )
				{
					bool converted;
					( *numericalPoint_ ) [ i ] = numbers[ i ].toDouble ( &converted );
					error |= ( !converted );
				}
				if ( !error )
				{
					emit updated();
				}
				return !error;
			}

		}

	}

}
