//                                               -*- C++ -*-
/**
 * @file		NumericalPointProperty.hxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2007-01-11 11:33:05
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#ifndef OPENTURNS_UI_GUINUMERICALPOINTPROPERTY_HXX
#define OPENTURNS_UI_GUINUMERICALPOINTPROPERTY_HXX

// OT::UI::GUI
#include "QOTProperty.hxx"

// OT
#include "NumericalPoint.hxx"

namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			typedef OT::Base::Type::NumericalPoint NumericalPoint;

			class NumericalPointProperty : public QOTProperty
			{
					Q_OBJECT
				public:
					NumericalPointProperty ( NumericalPoint* numericalPoint, const bool editable, QObject* parent, const char* name );

					~NumericalPointProperty();

					virtual QString getValue();
					virtual bool setValue ( QString value );
				protected:
					NumericalPoint* numericalPoint_;
			};

		}

	}

}

#endif
