//                                               -*- C++ -*-
/**
 * @file		NumericalSampleProperty.cxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2007-01-04 11:44:39
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "NumericalSampleProperty.hxx"

//OT::UI::GUI
#include "ExperimentProperty.hxx"

namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			NumericalSampleProperty::NumericalSampleProperty ( NumericalSample* numericalSample, QObject* parent, const char* name )
					: QOTProperty ( QOTProperty::MultipleChoice, parent, name )
			{
				numericalSample_ = numericalSample;
			}

			NumericalSampleProperty::~NumericalSampleProperty()
			{}

			QString NumericalSampleProperty::getValue()
			{
				return choice_;
			}

			QStringList NumericalSampleProperty::getChoices()
			{
				QStringList choices;
				choices << "design of experiment" << "file";
				return choices;
			}

			bool NumericalSampleProperty::setValue ( QString value )
			{
				if ( value != choice_ )
				{
					choice_ = value;

					QOTProperties subproperties = getSubproperties ( false );
					subproperties.setAutoDelete ( true );
					subproperties.clear();

					if ( choice_ == "design of experiment" )
					{
						QOTProperty * experimentProperty = new ExperimentProperty ( &experiment_, this, "type" );
						experimentProperty->setDefaultChoice();

						connect ( experimentProperty, SIGNAL ( updated() ), this, SLOT ( experimentUpdated() ) );

					}
					else if ( choice_ == "file" )
					{
						//new
					}
					emit updated();
					return true;
				}
				return false;
			}

			void NumericalSampleProperty::experimentUpdated()
			{
				qDebug ( "NumericalSampleProperty::experimentUpdated()" );
				( *numericalSample_ ) = experiment_.generate();
			}

		}

	}

}
