//                                               -*- C++ -*-
/**
 * @file		QOTFactory.hxx
 * @brief		QOTObject factory
 *
 * @author	Romuald Conty
 * @date		2006-09-13 11:21:13
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#ifndef OPENTURNS_GUIQOTFACTORY_HXX
#define OPENTURNS_GUIQOTFACTORY_HXX

// OT::UI::GUI
#include "QOTObject.hxx"
#include "Study.hxx"
#include "Parameter.hxx"

// Qt
#include <qiodevice.h>
#include <qxml.h>

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			class QOTFactory: public QXmlDefaultHandler
			{
				public:
					/** Default constructor */
					QOTFactory ( Study * parent );

					/** Destructor */
					virtual ~QOTFactory();

					/** load Xml file and start Xml parser */
					bool loadFromXml ( QIODevice * dev );

					/** event handler : a new Xml element */
					bool startElement ( const QString & namespaceURI, const QString & localName, const QString & qName, const QXmlAttributes & atts );

					/** event handler : end of element */
					bool endElement ( const QString & namespaceURI, const QString & localName, const QString & qName );

					/*
					  QValueList<QVariant> toQValueListQVariant( const QValueList<Parameter> parameters ) const;
					*/

				protected:
					QValueList<QVariant> parameters_;
					QString parametersName_;

					Study * parent_;
					QOTObjectList* objectList_;
			};
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

#endif
