//                                               -*- C++ -*-
/**
 * @file    QPropertiesBrowser.cxx
 * @brief
 *
 * @author  Romuald Conty
 * @date    2007-01-14 19:18:11
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#include "QPropertiesBrowser.hxx"

#include <qobject.h>
#include <qheader.h>
namespace OpenTURNS
{
	namespace UI
	{

		namespace GUI
		{

			QPropertiesBrowser::QPropertiesBrowser ( QWidget *parent, const char *name )
					: QTable ( 0, 4, parent, name )
			{
				otObject_ = NULL;

				setSelectionMode ( QTable::SingleRow );
				verticalHeader() ->hide();
				horizontalHeader() ->setLabel ( 0, "uuid" );
				horizontalHeader() ->setLabel ( 1, tr ( "property" ) );
				horizontalHeader() ->setLabel ( 2, tr ( "value" ) );
				horizontalHeader() ->setLabel ( 3, tr ( "" ) );
				setLeftMargin ( 0 );
				hideColumn ( 0 );

				setColumnStretchable ( 2, true );

				show();
				//header() ->hide();
			}


			QPropertiesBrowser::~QPropertiesBrowser()
			{}

			void QPropertiesBrowser::displayProperties ( QOTObject * otObject )
			{
				if ( otObject != otObject_ )
				{
					otObject_ = otObject;
					connect ( otObject, SIGNAL ( updated ( QOTProperty* ) ), this, SLOT ( propertyUpdated ( QOTProperty* ) ) );
					setNumRows ( 0 ); //clear()
					QOTProperties properties = otObject->getProperties ( true );
					//setNumRows( properties.count() );
					for ( uint i = 0; i < properties.count(); i++ )
					{
						QOTProperty * currentProperty = ( QOTProperty* ) properties.at ( i );
						createPropertiesBrowserRow ( i, currentProperty );
					}
				}
			}

			void QPropertiesBrowser::createPropertiesBrowserRow ( int row, QOTProperty* property )
			{
				const uint uuidCol = 0;
				const uint translatedNameCol = 1;
				const uint itemCol = 2;
				const uint toolbarCol = 3;


				// this->insertRows( row, 1 )
				if ( row >= this->numRows() )
				{
					row= this->numRows();
					this->setNumRows ( row + 1 );
				}
				else if ( row < this->numRows() )
				{
					this->insertRows ( row, 1 );
				}
				// "uuid"
				this->setItem ( row, uuidCol, new QTableItem ( this, QTableItem::Never, property->getUuid() ) );
				// "name" (translated)
				this->setCellWidget ( row, translatedNameCol, new QPropertiesBrowserNameItem ( this, property ) );

				// "value"
				switch ( property->getType() )
				{
					case QOTProperty::NotEditable :
					{
						this->setCellWidget ( row, itemCol, new QPropertiesBrowserTextItem ( this, property, false ) );
					}
					break;
					case QOTProperty::SimpleText :
					{
						this->setCellWidget ( row, itemCol, new QPropertiesBrowserTextItem ( this, property, true ) );
					}
					break;
					case QOTProperty::MultipleChoice :
					{
						this->setCellWidget ( row, itemCol, new QPropertiesBrowserComboBoxItem ( this, property ) );
					}
					break;
					default :
					{
						this->setCellWidget ( row, itemCol, new QPropertiesBrowserTextItem ( this, property, false ) );
					}
					break;
				}
				QToolBar* toolbar = createToolbar ( property );
				if ( toolbar )
				{
					this->setCellWidget ( row, toolbarCol, toolbar );
				}

				connect ( property, SIGNAL ( updated ( QOTProperty* ) ), this, SLOT ( propertyUpdated ( QOTProperty* ) ) );
				connect ( property, SIGNAL ( destroyed ( QOTProperty* ) ), this, SLOT ( propertyDestroyed ( QOTProperty* ) ) );

				this->adjustColumn ( translatedNameCol );
				this->adjustColumn ( itemCol );
				this->adjustColumn ( toolbarCol );
				this->adjustRow ( row );
			}

			void QPropertiesBrowser::propertyValueChanged ( int row, int col )
			{
				qDebug ( "QPropertiesBrowser::propertyValueChanged" );
				QWidget * widget = this->cellWidget ( row, col );
				Q_CHECK_PTR ( widget );
				if ( widget != NULL )
				{
					if ( widget->className() == "OpenTURNS::UI::GUI::QPropertiesBrowserTextItem" )
					{
						QPropertiesBrowserTextItem * textItem = ( QPropertiesBrowserTextItem* ) widget;

						const QString propertyValue = textItem->getText();

						QOTProperty* property = textItem->getProperty();
						Q_CHECK_PTR ( property );

						if ( !property->setValue ( propertyValue ) )
						{
							qDebug ( ( QString ( "QPropertiesBrowser::propertyValueChanged - Unable to set " ) + propertyValue + QString ( " as property's value of " ) + property->getName() + QString ( " property." ) ).ascii() );
							textItem->setText ( property->getValue() );
						}
					}
				}
			}

			void QPropertiesBrowser::propertyUpdated ( QOTProperty* property )
			{
				if ( findPropertyRow ( property ) == -1 )
				{
					qDebug ( ( QString ( "Property: " ) + property->getName() + QString ( " need to be dynamically created." ) ).ascii() );
					createPropertiesBrowserRow ( property->getRank(), property );
				}
			}

			void QPropertiesBrowser::propertyDestroyed ( QOTProperty* property )
			{
				const int row = findPropertyRow ( property );
				if ( row != -1 )
				{
					removeRow ( row );
				}
				else
				{
					qWarning ( "Unable to find the property!" );
				}
			}

			QToolBar* QPropertiesBrowser::createToolbar ( QOTProperty* property )
			{
				QToolBar * toolBar = NULL;
				QOTActions actions ( property->getActions() );
				if ( actions.count() )
				{
					toolBar = new QToolBar();
					for ( uint i = 0; i < actions.count(); i++ )
					{
						actions.at ( i ) ->addTo ( toolBar );
					}
				}
				return toolBar;
			}

			int QPropertiesBrowser::findPropertyRow ( QOTProperty* property )
			{
				const uint uuidCol = 0;
				const uint itemCol = 2;

				for ( int i = 0; i < numRows(); i++ )
				{
					QWidget* widget = cellWidget ( i, itemCol );
					Q_CHECK_PTR ( widget );
					if ( widget )
					{
						/** @warning you can't cast widget ( ie: QPropertiesBrowserComboBoxItem ) into QPropertyBrowserItem
						QOTProperty * currentProperty = item->getProperty();
						QPropertiesBrowserItem * item = ( QPropertiesBrowserItem* ) widget;
						if ( currentProperty == property ) {
						*/
						if ( property->getUuid() == text ( i, uuidCol ) )
						{
							return i;
						}
					}
				}
				return -1;
			}

		}
	}
}
