//                                               -*- C++ -*-
/**
 * @file		QPropertiesBrowserItem.hxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2007-01-09 11:22:28
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#ifndef OPENTURNS_UI_GUIQPROPERTIESBROWSERITEM_HXX
#define OPENTURNS_UI_GUIQPROPERTIESBROWSERITEM_HXX

// Qt
#include <qwidget.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qtable.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qframe.h>

// OT::UI::GUI
#include "QOTProperty.hxx"

namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			/** @class QPropertiesBrowserItem
			 */
			class QPropertiesBrowserItem
			{
				public:
					QPropertiesBrowserItem ( QOTProperty * property );

					virtual ~QPropertiesBrowserItem();

					QOTProperty* getProperty();

					virtual QString getText() = 0;
					virtual void setText ( const QString& text ) = 0;

				protected:
					QOTProperty * property_;

				protected:
					void updateProperty ( const QString& value );

			};


			/** @class QPropertiesBrowserNameItem
			 */
			class QPropertiesBrowserNameItem: public QWidget, public QPropertiesBrowserItem
			{
					Q_OBJECT
				public:
					QPropertiesBrowserNameItem ( QTable* table, QOTProperty* property );

					~QPropertiesBrowserNameItem();

					QString getText();
					void setText ( const QString& text );
			};


			/** @class QPropertiesBrowserComboBoxItem
			 */
			class QPropertiesBrowserComboBoxItem: public QWidget, public QPropertiesBrowserItem
			{
					Q_OBJECT
				public:
					QPropertiesBrowserComboBoxItem ( QTable* table, QOTProperty* property );

					~QPropertiesBrowserComboBoxItem();

					QString getText();
					void setText ( const QString& text );

				public slots:
					void propertyUpdated();

				protected slots:
					void selectionChanged ( const QString& value );

				protected:
					QComboBox* combobox_;
			};


			/** @class QPropertiesBrowserTextItem
			 */
			class QPropertiesBrowserTextItem: public QWidget, public QPropertiesBrowserItem
			{
					Q_OBJECT
				public:
					QPropertiesBrowserTextItem ( QTable* table, QOTProperty* property, bool editable );
					~QPropertiesBrowserTextItem();

					QString getText();
					void setText ( const QString& text );

				public slots:
					void propertyUpdated();

				protected slots:
					void textChanged();

				protected:
					QLineEdit* edit_;
			};

		}

	}

}

#endif
