//                                               -*- C++ -*-
/**
 * @file    QVisualizationFrame.cxx
 * @brief
 *
 * @author  Romuald Conty
 * @date    2006-12-17 22:56:02
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#include "QVisualizationFrame.hxx"

#include <qgroupbox.h>
#include <qlayout.h>


namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			QVisualizationFrame::QVisualizationFrame ( QWidget *parent, const char *name )
					: QSplitter ( parent, name )
			{
				this->setOrientation ( Qt::Vertical );
				this->setSizePolicy ( QSizePolicy::Expanding, QSizePolicy::Expanding );

				visualizationTable_ = new QVisualizationTable ( "", this, "VisualizationTable" );

				QGroupBox* propertyBox = new QGroupBox ( this, "Properties" );
				propertyBox->setTitle ( tr ( "Properties" ) );

				QBoxLayout * propertiesBoxLayout = new QHBoxLayout ( propertyBox );

				propertiesBrowser_ = new QPropertiesBrowser ( propertyBox, "PropertiesBrowser" );
				propertiesBrowser_->setSizePolicy ( QSizePolicy::Expanding, QSizePolicy::Expanding );
				propertiesBoxLayout->addWidget ( propertiesBrowser_, 1 );

				tableProperties_ = new QPropertiesTable ( propertyBox );
				tableProperties_->setSizePolicy ( QSizePolicy::Expanding, QSizePolicy::Expanding );
				propertiesBoxLayout->addWidget ( tableProperties_, 1 );

				// Used to debug XML save/restore
				tableProperties_->hide();

				// Size policies
				propertyBox->setSizePolicy ( QSizePolicy::Expanding, QSizePolicy::Ignored );
				propertyBox->setMinimumHeight ( 500 );

				visualizationTable_->setSizePolicy ( QSizePolicy::Expanding, QSizePolicy::MinimumExpanding );
				visualizationTable_->setMinimumHeight ( 300 );

				connect ( visualizationTable_, SIGNAL ( clicked ( QOTObject * ) ) , this, SLOT ( showPropertiesAbout ( QOTObject * ) ) );
			}


			QVisualizationFrame::~QVisualizationFrame()
			{}

			void QVisualizationFrame::showPropertiesAbout ( QOTObject* object )
			{
				Q_CHECK_PTR ( object );
				this->setCaption ( object->getName() );
				tableProperties_->displayProperties ( object );
				propertiesBrowser_->displayProperties ( object );
			}

			bool QVisualizationFrame::isEmpty()
			{
				return ! ( visualizationTable_->numRows() );
			}

			void QVisualizationFrame::visualize ( QOTObject* otObject )
			{
				visualizationTable_->clear();
				visualizationTable_->append ( otObject, true );
			}
		}

	}

}
