//                                               -*- C++ -*-
/**
 * @file		Result.hxx
 * @brief		Unified result display object
 *
 * @author	Romuald Conty
 * @date		2006-11-09 20:35:18
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-09-13 22:37:56 +0200 (sam 13 sep 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#ifndef OPENTURNS_UI_GUIRESULT_HXX
#define OPENTURNS_UI_GUIRESULT_HXX

// OT::UI::GUI
#include "Content.hxx"

// OT
#include "CovarianceMatrix.hxx"

#include "Simulation.hxx"

#include "FORM.hxx"
#include "SORM.hxx"
#include "StrongMaximumTest.hxx"

// Qt
#include <qdatetime.h>

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{
			typedef OT::Base::Type::NumericalPoint   NumericalPoint;
			typedef OT::Base::Stat::NumericalSample  NumericalSample;
			typedef OT::Base::Stat::CovarianceMatrix CovarianceMatrix;

			typedef OT::Uncertainty::Algorithm::Simulation::Result SimulationResult;
			typedef OT::Uncertainty::Algorithm::FORMResult         FormResult;
			typedef OT::Uncertainty::Algorithm::SORMResult         SormResult;
			typedef OT::Uncertainty::Algorithm::StrongMaximumTest  StrongMaximumTestResult;

			typedef struct CentralDispersionResult
			{
				NumericalPoint   mean;
				CovarianceMatrix covariance;
			}
			CentralDispersionResult;

			class Result : public Content
			{
					Q_OBJECT
					Q_PROPERTY ( QValueList elements READ getElements )

				public:
					Result ( QOTObject *parent, const char *name, QDateTime start, QDateTime end, SimulationResult result );
					Result ( QOTObject *parent, const char *name, QDateTime start, QDateTime end, FormResult result );
					Result ( QOTObject *parent, const char *name, QDateTime start, QDateTime end, SormResult result );
					Result ( QOTObject *parent, const char *name, QDateTime start, QDateTime end, StrongMaximumTestResult result );
					Result ( QOTObject *parent, const char *name, QDateTime start, QDateTime end, CentralDispersionResult result );

					~Result();

					/** Result elements accessor (designed for Q_PROPERTY macro) */
					QValueList<QVariant> getElements() const;

				protected:
					QDateTime calculationStart_;
					QDateTime calculationEnd_;

					QValueList<QVariant> elements_;

					void addElement ( QString element, NumericalScalar value );
					void addElement ( QString element, NumericalPoint value );
					void addElement ( QString element, QString value );
			};

		}

	}

}

#endif
