//                                               -*- C++ -*-
/**
 * @file    StrongMaximumTestProperty.hxx
 * @brief
 *
 * @author  Romuald Conty
 * @date    2007-01-14 11:47:34
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#ifndef OPENTURNS_UI_GUISTRONGMAXIMUMTESTPROPERTY_HXX
#define OPENTURNS_UI_GUISTRONGMAXIMUMTESTPROPERTY_HXX

#include <YesNoProperty.hxx>

namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			class StrongMaximumTestProperty : public YesNoProperty
			{
					Q_OBJECT
				public:
					StrongMaximumTestProperty ( QObject* parent, const char* name );

					~StrongMaximumTestProperty();

					virtual bool setValue ( QString value );

					bool isEnabled() const;
					NumericalScalar getImportanceLevel() const;
					NumericalScalar getAccuracyLevel() const;
					NumericalScalar getConfidenceLevel() const;


				protected:
					bool enabled_;
					NumericalScalar importanceLevel_;
					NumericalScalar accuracyLevel_;
					NumericalScalar confidenceLevel_;

			};

		}

	}

}

#endif
