//                                               -*- C++ -*-
/**
 * @file		ThresholdExceedance.hxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2006-08-28 10:21:04
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2007-11-08 17:13:40 +0100 (jeu 08 nov 2007) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#ifndef OPENTURNS_GUITHRESHOLDEXCEEDANCE_HXX
#define OPENTURNS_GUITHRESHOLDEXCEEDANCE_HXX

// OT::UI::GUI
#include "Criterion.hxx"

// OT
#include "OT.hxx"
#include "Pointer.hxx"
#include "ComparisonOperator.hxx"

namespace OpenTURNS
{
	namespace UI
	{
		namespace GUI
		{

			typedef OT::Base::Common::ComparisonOperator ComparisonOperator;

			class ThresholdExceedance : public Criterion
			{
					Q_OBJECT

				public:
					/** Default constructor */
					ThresholdExceedance ( QOTObject *parent, const char *name = 0 );

					/** Copy constructor */
					ThresholdExceedance ( const ThresholdExceedance & other, QOTObject* parent );

					/** Destructor */
					virtual ~ThresholdExceedance();

					/** The function that actually realizes assignment between objects */
					void assignToMe ( const ThresholdExceedance & other );

					/** ThresholdExceedance threshold value accessor */
					NumericalScalar getThreshold() const;

					ComparisonOperator getOperator() const;

				protected:
					ComparisonOperator comparisonOperator_;

					NumericalScalar threshold_;
			};
		} /* namespace GUI */
	} /* namespace UI */
} /* namespace OpenTURNS */

#endif
