//                                               -*- C++ -*-
/**
 * @file    ThresholdExceedanceMethodProperty.cxx
 * @brief
 *
 * @author  Romuald Conty
 * @date    2007-01-14 11:42:04
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "ThresholdExceedanceMethodProperty.hxx"

namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			ThresholdExceedanceMethodProperty::ThresholdExceedanceMethodProperty ( QObject *parent, const char *name )
					: QOTProperty ( QOTProperty::MultipleChoice, parent, name )
			{
				shootCount_ = 100;
				calculationTime_ = 120;
				precision_ = .1;
			}


			ThresholdExceedanceMethodProperty::~ThresholdExceedanceMethodProperty()
			{}

			QString ThresholdExceedanceMethodProperty::getValue()
			{
				return method_;
			}

			QStringList ThresholdExceedanceMethodProperty::getChoices()
			{
				QStringList choices;
				choices << "monte carlo" << "LHS" << "importance sampling" << "directional sampling" << "FORM" << "SORM";
				return choices;
			}

			bool ThresholdExceedanceMethodProperty::setValue ( QString value )
			{
				if ( method_ != value )
				{
					method_ = value;
					QOTProperties subproperties = getSubproperties ( false );
					subproperties.setAutoDelete ( true );
					subproperties.clear();

					nearestPointAlgorithmProperty_ = NULL;
					strongMaximumTestProperty_ = NULL;

					if ( method_ == "monte carlo" )
					{
						createSimulationProperties();
					}
					else if ( method_ == "LHS" )
					{
						createSimulationProperties();
					}
					else if ( method_ == "importance sampling" )
					{
						createSimulationProperties();
						createOptimizationProperties();
					}
					else if ( method_ == "directional sampling" )
					{
						createSimulationProperties();
					}
					else if ( method_ == "FORM" )
					{
						createOptimizationProperties();
					}
					else if ( method_ == "SORM" )
					{
						createOptimizationProperties();
					}
					emit updated();
					return true;
				}
				return false;
			}

			void ThresholdExceedanceMethodProperty::createSimulationProperties()
			{
				propertyUpdated ( new UnsignedLongProperty ( &shootCount_, true, this, "shoot count" ) );
				//propertyUpdated( new UnsignedLongProperty( &calculationTime_, true, this, "calculation time" ) );
				propertyUpdated ( new NumericalScalarProperty ( &precision_, true, this, "precision" ) );
			}

			void ThresholdExceedanceMethodProperty::createOptimizationProperties()
			{
				nearestPointAlgorithmProperty_ = new NearestPointAlgorithmProperty ( &nearestPointAlgorithm_, this, "optimization" );
				nearestPointAlgorithmProperty_->setDefaultChoice();

				strongMaximumTestProperty_ = new StrongMaximumTestProperty ( this, "strong maximum test" );
				strongMaximumTestProperty_->setDefaultChoice();

				propertyUpdated ( nearestPointAlgorithmProperty_ );
				propertyUpdated ( strongMaximumTestProperty_ );
			}

			void ThresholdExceedanceMethodProperty::propertyUpdated ( QOTProperty* subproperty )
			{
				emit updated ( subproperty );
			}

			QString ThresholdExceedanceMethodProperty::getMethod() const
			{
				return method_;
			}

			UnsignedLong ThresholdExceedanceMethodProperty::getShootCount() const
			{
				return shootCount_;
			}

			NumericalScalar ThresholdExceedanceMethodProperty::getPrecision() const
			{
				return precision_;
			}

			NearestPointAlgorithm ThresholdExceedanceMethodProperty::getNearestPointAlgorithm() const
			{
				return nearestPointAlgorithm_;
			}

			StrongMaximumTestProperty* ThresholdExceedanceMethodProperty::getStrongMaximumTextProperty()
			{
				return strongMaximumTestProperty_;
			}

		}

	}

}
