//                                               -*- C++ -*-
/**
 * @file		UnsignedLongProperty.cxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2007-01-11 11:43:48
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "UnsignedLongProperty.hxx"

namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			UnsignedLongProperty::UnsignedLongProperty ( UnsignedLong* unsignedLong, const bool editable, QObject *parent, const char *name )
					: QOTProperty ( ( ( editable ) ? ( QOTProperty::SimpleText ) : ( QOTProperty::NotEditable ) ), parent, name )
			{
				unsignedLong_ = unsignedLong;
			}


			UnsignedLongProperty::~UnsignedLongProperty()
			{}

			QString UnsignedLongProperty::getValue()
			{
				return QString::number ( *unsignedLong_ );
			}

			bool UnsignedLongProperty::setValue ( QString value )
			{
				bool converted;
				UnsignedLong unsignedLong;
				unsignedLong = value.toULong ( &converted );
				if ( converted && ( unsignedLong != ( *unsignedLong_ ) ) )
				{
					( *unsignedLong_ ) = unsignedLong;
					emit updated();
					return true;
				}
				return false;
			}

		}

	}

}
