//                                               -*- C++ -*-
/**
 * @file		VariableTypeProperty.cxx
 * @brief
 *
 * @author	Romuald Conty
 * @date		2007-01-10 11:39:49
 *
 * @par Last change :
 *  $LastChangedBy: dutka $
 *  $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
// Header
#include "VariableTypeProperty.hxx"

namespace OpenTURNS
{

	namespace UI
	{

		namespace GUI
		{

			VariableTypeProperty::VariableTypeProperty ( VariableType* variableType, QObject* parent, const char* name ) : QOTProperty ( QOTProperty::MultipleChoice, parent, name )
			{
				variableType_ = variableType;
			}


			VariableTypeProperty::~VariableTypeProperty()
			{}


			QString VariableTypeProperty::getValue()
			{
				if ( ( *variableType_ ) == Stochastic )
				{
					return "stochastic";
				}
				else
				{
					return "determistic";
				}
			}

			QStringList VariableTypeProperty::getChoices()
			{
				QStringList choices;
				choices << "determistic" << "stochastic";
				return choices;
			}

			bool VariableTypeProperty::setValue ( QString value )
			{
				VariableType variableType;
				if ( value == "stochastic" )
				{
					variableType = Stochastic;
				}
				else
				{
					variableType = Deterministic;
				}

				if ( ( *variableType_ ) != variableType )
				{
					( *variableType_ ) = variableType;
					emit updated();
					return true;
				}
				return false;
			}

			void VariableTypeProperty::propertyUpdated ( QOTProperty* subproperty )
			{
				emit updated ( subproperty );
			}


		}

	}

}
