#                                               -*- Autoconf -*-
#
#  ot_check_regex.m4
#
#  (C) Copyright 2005-2007 EDF-EADS-Phimeca
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License.
#
#  This library is distributed in the hope that it will be useful
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
#  @author: $LastChangedBy: dutka $
#  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
#  Id:      $Id: ot_check_regex.m4 862 2008-06-26 11:50:17Z dutka $
#
#
#  This file is intended to be include in the configure.in file
#  of Open TURNS project to check whether reguler expressions are 
#  available on the platform.
#
# OT_CHECK_REGEX([ DIR = /usr ])
# ------------------------------
#
AC_DEFUN([OT_CHECK_REGEX],
[
 AC_ARG_WITH([regex],
  AC_HELP_STRING([--with-regex@<:@=DIR@:>@], [add regular expression support. @<:@]m4_default([$1], /usr)[@:>@]),
                 [], [withval=yes])

  WITH_REGEX=0

  # saving values for compilation variables
  saved_CPPFLAGS=$CPPFLAGS
  saved_LDFLAGS=$LDFLAGS
  saved_LIBS=$LIBS

  regex_default_path=m4_default([$1], /usr)
  if ! test x${withval} = xno
  then
    # ask for Regex support
    AC_MSG_NOTICE([checking whether regular expressions are here and working])

    # we're trying to find the correct Regex installation path
    regex_install_path=$regex_default_path
    test x${withval} = xyes || regex_install_path=$withval

    AC_MSG_CHECKING([Regex install path])
    test -d ${regex_install_path} || AC_MSG_ERROR([$regex_install_path: incorrect path])
    AC_MSG_RESULT([$regex_install_path])



    # we test the header file presence and usability
    regex_include_path=$regex_install_path/include
    CPPFLAGS="${CPPFLAGS} -I${regex_include_path}"
    AC_LANG_PUSH(C)
    AC_CHECK_HEADERS([regex.h],
                     [regex_header_found=yes],
                     [regex_header_found=no],
                     [])
    AC_LANG_POP(C)
    test x${regex_header_found} = xno && AC_MSG_ERROR([Regex include file NOT FOUND])
    AC_SUBST(regex_include_path)

    # we test the library file presence and usability
    regex_lib_path=$regex_install_path/lib
    regex_lib_name=c
    LDFLAGS="${LDFLAGS} -L${regex_lib_path}"
    LIBS="${LIBS} -l${regex_lib_name}"
    AC_SEARCH_LIBS([regexec], [$regex_lib_name], [regex_lib_found=yes], [regex_lib_found=no])
    test x${regex_lib_found} = xno && AC_MSG_ERROR([Regex library NOT FOUND])
    AC_SUBST(regex_lib_path)
    AC_SUBST(regex_lib_name)



    # after all tests are successful, we support Regex
    WITH_REGEX=1
    AC_MSG_NOTICE([Regex support is OK])

  else
    # no Regex support
    AC_MSG_NOTICE([No Regex support])
  fi

  # Propagate test into atlocal
  AC_SUBST(WITH_REGEX)

  # Propagate test into Makefiles...
  AM_CONDITIONAL(WITH_REGEX, test $WITH_REGEX = 1)

  # ... and into source files
  AC_DEFINE_UNQUOTED(HAS_REGEX, $WITH_REGEX, [Support for regular expression library])

  # restoring saved values
  CPPFLAGS=$saved_CPPFLAGS
  LDFLAGS=$saved_LDFLAGS
  LIBS=$saved_LIBS

])
